/*
 * Decompiled with CFR 0.152.
 */
package com.ayoree.simpleplayerscale;

import com.ayoree.simpleplayerscale.SimplePlayerScale;
import com.ayoree.simpleplayerscale.utility.ScaleClass;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private final Plugin plugin;
    protected final File configFile;
    public static String PREFIX = "\u00a7f[\u00a7lP\u00a7r\u00a77layer\u00a7f\u00a7lS\u00a7r\u00a77cale\u00a7f] \u00a7r";
    public static String MSG_CHANGE = "\u00a7a\u0412\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0438 \u0432\u0430\u0448 \u0440\u0430\u0437\u043c\u0435\u0440 \u043d\u0430 {scale}";
    public static String MSG_INCORRECT_ARGS = "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430\u00a7e - \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00a7l/pscale <\u0447\u0438\u0441\u043b\u043e>";
    public static String MSG_CONFIG_RELOAD = "\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d";
    public static String MSG_NO_PERMISSION = "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b";
    public static String MSG_RG_FLAG = "\u00a7c\u0412 \u0434\u0430\u043d\u043d\u043e\u043c \u0440\u0435\u0433\u0438\u043e\u043d\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430";
    public static String MSG_OLD_VERSION = "\u00a7c\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430 \u043c\u043e\u0436\u043d\u043e \u043c\u0435\u043d\u044f\u0442\u044c \u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 1.20.5 \u0438 \u0432\u044b\u0448\u0435";
    public static Map<String, ScaleClass> groupScales = new HashMap<String, ScaleClass>();

    public Config(SimplePlayerScale plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.loadAll();
    }

    private void loadAll() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        PREFIX = config.getString("prefix", PREFIX);
        MSG_CHANGE = config.getString("scale-change-msg", MSG_CHANGE);
        MSG_INCORRECT_ARGS = config.getString("incorrect-args-msg", MSG_INCORRECT_ARGS);
        MSG_CONFIG_RELOAD = config.getString("reload-config-msg", MSG_CONFIG_RELOAD);
        MSG_NO_PERMISSION = config.getString("no-permission-msg", MSG_NO_PERMISSION);
        MSG_RG_FLAG = config.getString("rg-flag-msg", MSG_RG_FLAG);
        groupScales.clear();
        ConfigurationSection groupsSection = config.getConfigurationSection("scales");
        if (groupsSection != null) {
            for (String group : groupsSection.getKeys(false)) {
                ScaleClass scale = new ScaleClass();
                scale.min = config.getDouble("scales." + group + ".min", 1.0);
                scale.max = config.getDouble("scales." + group + ".max", 1.0);
                groupScales.put(group, scale);
            }
        }
    }
}

