/*
 * Decompiled with CFR 0.152.
 */
package com.ayoree.simpleplayerscale.commands;

import com.ayoree.simpleplayerscale.Config;
import com.ayoree.simpleplayerscale.SimplePlayerScale;
import com.ayoree.simpleplayerscale.flags.PlayerScaleFlags;
import com.ayoree.simpleplayerscale.utility.MessageUtility;
import com.ayoree.simpleplayerscale.utility.PlayerUtility;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        block11: {
            if (args.length > 0) {
                if (args[0].equals("reload")) {
                    if (sender.hasPermission("playerscale.reload")) {
                        SimplePlayerScale.config.loadConfig();
                        MessageUtility.processMessage(Config.MSG_CONFIG_RELOAD, sender);
                    } else {
                        MessageUtility.processMessage(Config.MSG_NO_PERMISSION, sender);
                    }
                } else {
                    try {
                        if (!(sender instanceof Player)) break block11;
                        Player player = (Player)sender;
                        if (Bukkit.getPluginManager().getPlugin("ViaVersion") != null && PlayerUtility.getPlayerProtocolVersion(player) < Objects.requireNonNull(ProtocolVersion.getClosest((String)"1.20.5")).getVersion()) {
                            player.sendMessage(Config.MSG_OLD_VERSION);
                            return true;
                        }
                        Location loc = new Location((Extent)BukkitAdapter.adapt((World)player.getWorld()), player.getX(), player.getY(), player.getZ());
                        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                        RegionQuery query = container.createQuery();
                        ApplicableRegionSet set = query.getApplicableRegions(loc);
                        for (ProtectedRegion region : set) {
                            StateFlag.State flag = (StateFlag.State)region.getFlag((Flag)PlayerScaleFlags.playerScaleFlag);
                            if (flag == null || StateFlag.test((StateFlag.State[])new StateFlag.State[]{flag})) continue;
                            player.sendMessage(Config.MSG_RG_FLAG);
                            return true;
                        }
                        double scale = Double.parseDouble(args[0]);
                        PlayerUtility playerUtility = new PlayerUtility(player);
                        scale = playerUtility.calculatePlayerScale(scale);
                        if (sender.hasPermission("playerscale.set")) {
                            MessageUtility.processMessage(Config.MSG_CHANGE, player, scale);
                            PlayerUtility.setScale(player, scale);
                            break block11;
                        }
                        MessageUtility.processMessage(Config.MSG_NO_PERMISSION, sender);
                    }
                    catch (Exception e) {
                        MessageUtility.processMessage(Config.MSG_INCORRECT_ARGS, sender);
                    }
                }
            } else {
                MessageUtility.processMessage(Config.MSG_INCORRECT_ARGS, sender);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("playerscale.reload") && "reload".startsWith(args[0])) {
                suggestions.add("reload");
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlayerUtility playerUtility = new PlayerUtility(player);
                double maxPlayerScale = playerUtility.getMaxPlayerScale();
                double minPlayerScale = playerUtility.getMinPlayerScale();
                int i = (int)(minPlayerScale * 10.0);
                while ((double)i <= maxPlayerScale * 10.0) {
                    suggestions.add(i / 10 + "." + i % 10);
                    ++i;
                }
            }
            suggestions.removeIf(suggestion -> !suggestion.startsWith(args[0]));
        }
        return suggestions;
    }
}

