/*
 * Decompiled with CFR 0.152.
 */
package com.ayoree.simpleplayerscale.events;

import com.ayoree.simpleplayerscale.SimplePlayerScale;
import com.ayoree.simpleplayerscale.utility.PlayerUtility;
import com.ayoree.simpleplayerscale.utility.SavePlayerUtility;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.io.File;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinLeaveEvent
implements Listener {
    private final SimplePlayerScale plugin;

    public JoinLeaveEvent(SimplePlayerScale plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent e) {
        PlayerUtility playerUtility = new PlayerUtility(e.getPlayer());
        File playerDataFile = playerUtility.getPlayerDataFile();
        if (playerDataFile.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerDataFile);
            double scale = cfg.getDouble("scale", playerUtility.getMaxPlayerScale());
            Player player = e.getPlayer();
            if (Bukkit.getPluginManager().getPlugin("ViaVersion") != null && PlayerUtility.getPlayerProtocolVersion(player) < Objects.requireNonNull(ProtocolVersion.getClosest((String)"1.20.5")).getVersion()) {
                return;
            }
            PlayerUtility.setScale(player, scale);
        } else {
            double scale = 1.0;
            PlayerUtility.save(e.getPlayer(), scale);
        }
    }

    @EventHandler
    private void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        PlayerUtility playerUtility = new PlayerUtility(player);
        SavePlayerUtility saveUtility = new SavePlayerUtility(player, this.plugin);
        double scale = playerUtility.getPlayerScale();
        if (scale == 1.0) {
            saveUtility.delete();
        } else {
            saveUtility.save(scale);
        }
        PlayerUtility.remove(player);
    }
}

