/*
 * Decompiled with CFR 0.152.
 */
package com.ayoree.simpleplayerscale.utility;

import com.ayoree.simpleplayerscale.Config;
import com.ayoree.simpleplayerscale.SimplePlayerScale;
import com.ayoree.simpleplayerscale.utility.ClampUtility;
import com.ayoree.simpleplayerscale.utility.ScaleClass;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;

public class PlayerUtility {
    private final Player player;
    private static final Map<String, Double> PlayerDataHandlerMap = new HashMap<String, Double>();
    private static final ClampUtility clampUtility = new ClampUtility();

    public PlayerUtility(Player player) {
        this.player = player;
    }

    public double getPlayerScale() {
        double scale = PlayerDataHandlerMap.getOrDefault(this.player.getName().toLowerCase(), 1.0);
        return clampUtility.clampScale(scale);
    }

    public static double getPlayerScale(Player player) {
        AttributeInstance scale = player.getAttribute(Attribute.GENERIC_SCALE);
        if (scale != null) {
            return scale.getBaseValue();
        }
        return 1.0;
    }

    public double getMaxPlayerScale() {
        return this.getMaxPlayerScale(true);
    }

    public double getMinPlayerScale() {
        return this.getMinPlayerScale(true);
    }

    public double calculatePlayerScale(double scale) {
        scale = clampUtility.clampScale(scale);
        scale = Math.min(scale, this.getMaxPlayerScale(false));
        scale = Math.max(scale, this.getMinPlayerScale(false));
        return scale;
    }

    private double getMaxPlayerScale(boolean clamp) {
        double scale = 1.0;
        for (String group : this.getPlayerGroups()) {
            ScaleClass groupScale = Config.groupScales.get(group);
            scale = groupScale != null ? Math.max(scale, groupScale.max) : scale;
        }
        if (clamp) {
            return clampUtility.clampScale(scale);
        }
        return scale;
    }

    private double getMinPlayerScale(boolean clamp) {
        double scale = 1.0;
        for (String group : this.getPlayerGroups()) {
            ScaleClass groupScale = Config.groupScales.get(group);
            scale = groupScale != null ? Math.min(scale, groupScale.min) : scale;
        }
        if (clamp) {
            return clampUtility.clampScale(scale);
        }
        return scale;
    }

    public File getPlayerDataFile() {
        File dataFolder = ((SimplePlayerScale)SimplePlayerScale.getPlugin(SimplePlayerScale.class)).getDataFolder();
        return new File(dataFolder, "players/" + this.player.getName().toLowerCase() + ".yml");
    }

    private List<String> getPlayerGroups() {
        ArrayList<String> lst = new ArrayList<String>();
        Config.groupScales.forEach((group, scale) -> {
            if (this.player.hasPermission("group." + group)) {
                lst.add((String)group);
            }
        });
        return lst;
    }

    public static void setScale(Player player, double newScale) {
        AttributeInstance scale = player.getAttribute(Attribute.GENERIC_SCALE);
        if (scale == null) {
            return;
        }
        scale.setBaseValue(newScale);
        PlayerUtility.save(player, newScale);
    }

    public static void save(Player player, double scale) {
        PlayerDataHandlerMap.put(player.getName().toLowerCase(), scale);
    }

    public static void remove(Player player) {
        PlayerDataHandlerMap.remove(player.getName().toLowerCase());
    }

    public static int getPlayerProtocolVersion(Player player) {
        UserConnection userConnection = Via.getManager().getConnectionManager().getConnectedClient(player.getUniqueId());
        if (userConnection == null) {
            return 0;
        }
        return userConnection.getProtocolInfo().protocolVersion().getVersion();
    }
}

