/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.garden.GardenRegistry;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.PlantItem;
import dev.jsinco.brewery.garden.plant.PlantType;
import dev.jsinco.brewery.garden.plant.Seeds;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class PlantItemArgument
implements CustomArgumentType.Converted<PlantItem, String> {
    private static final DynamicCommandExceptionType ERROR_ILLEGAL_ARGUMENT = new DynamicCommandExceptionType(invalidArgument -> (Message)MessageComponentSerializer.message().serialize(MiniMessage.miniMessage().deserialize("Illegal argument <argument>", (TagResolver)Placeholder.unparsed((String)"argument", (String)invalidArgument.toString()))));
    private final Map<String, PlantItem> items = new HashMap<String, PlantItem>();

    public PlantItemArgument() {
        for (PlantType plant : GardenRegistry.PLANT_TYPE.values()) {
            Seeds seeds = plant.newSeeds();
            this.items.put(seeds.simpleName(), seeds);
            Fruit fruit = plant.newFruit();
            this.items.put(fruit.simpleName(), fruit);
        }
    }

    public PlantItem convert(String string) throws CommandSyntaxException {
        PlantItem plantType = this.items.get(string);
        if (plantType == null) {
            throw ERROR_ILLEGAL_ARGUMENT.create((Object)string);
        }
        return plantType;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        this.items.keySet().stream().filter(itemName -> itemName.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

