/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util.BlockHelper;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.persistence.PersistentDataType;

public class EntityEventListener
implements Listener {
    private final BlockUtil blockUtilAPI;
    private static final NamespacedKey NO_BLOCK_DROP = new NamespacedKey("blockutil", "no_block_drop");

    public EntityEventListener(BlockUtil blockUtilAPI) {
        this.blockUtilAPI = blockUtilAPI;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onMonsterSpawn(CreatureSpawnEvent event) {
        Block baseBlock = event.getLocation().getBlock();
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN && this.checkSnowman(baseBlock)) {
            event.setCancelled(true);
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM && this.checkIronGolem(baseBlock)) {
            event.setCancelled(true);
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BUILD_WITHER && this.checkWither(baseBlock)) {
            event.setCancelled(true);
        }
    }

    private boolean checkWither(Block baseBlock) {
        Stream<Block> blockStream = Stream.of(baseBlock, baseBlock.getRelative(0, 1, 0), baseBlock.getRelative(1, 1, 0), baseBlock.getRelative(-1, 1, 0), baseBlock.getRelative(0, 1, 1), baseBlock.getRelative(0, 1, -1), baseBlock.getRelative(0, 2, 0), baseBlock.getRelative(1, 2, 0), baseBlock.getRelative(-1, 2, 0), baseBlock.getRelative(0, 2, 1), baseBlock.getRelative(0, 2, -1));
        return blockStream.anyMatch(this.blockUtilAPI::blockItemDropsDisabled);
    }

    private boolean checkIronGolem(Block baseBlock) {
        Stream<Block> blockStream = Stream.of(baseBlock, baseBlock.getRelative(0, 1, 0), baseBlock.getRelative(1, 1, 0), baseBlock.getRelative(-1, 1, 0), baseBlock.getRelative(0, 1, 1), baseBlock.getRelative(0, 1, -1), baseBlock.getRelative(0, 2, 0));
        return blockStream.anyMatch(this.blockUtilAPI::blockItemDropsDisabled);
    }

    private boolean checkSnowman(Block baseBlock) {
        Stream<Block> blockStream = Stream.of(baseBlock, baseBlock.getRelative(0, 1, 0), baseBlock.getRelative(0, 2, 0));
        return blockStream.anyMatch(this.blockUtilAPI::blockItemDropsDisabled);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block up;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            if (event.getBlock().getType().isAir()) {
                if (event.getEntity().getPersistentDataContainer().has(NO_BLOCK_DROP)) {
                    this.blockUtilAPI.disableItemDrops(event.getBlock());
                }
            } else if (this.blockUtilAPI.blockItemDropsDisabled(event.getBlock())) {
                event.getEntity().getPersistentDataContainer().set(NO_BLOCK_DROP, PersistentDataType.BOOLEAN, (Object)true);
                fallingBlock.setDropItem(false);
                this.blockUtilAPI.enableItemDrops(event.getBlock());
            }
            return;
        }
        if (event.getEntity() instanceof Wither) {
            BlockHelper.breakBlock(event.getBlock(), this.blockUtilAPI);
        }
        if (event.getBlock().getType() == Material.FARMLAND && this.blockUtilAPI.blockItemDropsDisabled(up = event.getBlock().getRelative(BlockFace.UP))) {
            event.setCancelled(true);
            BlockHelper.breakBlock(up, this.blockUtilAPI);
            event.getBlock().setBlockData(event.getBlockData());
        }
    }
}

