/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.eu.okaeri.configs.yaml.bukkit.serdes.transformer;

import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.schema.GenericsPair;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.serdes.BidirectionalTransformer;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.serdes.SerdesContext;
import java.util.Locale;
import lombok.NonNull;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;

public class StringBiomeTransformer
extends BidirectionalTransformer<String, Biome> {
    @Override
    public GenericsPair<String, Biome> getPair() {
        return this.genericsPair(String.class, Biome.class);
    }

    @Override
    public Biome leftToRight(@NonNull String data, @NonNull SerdesContext serdesContext) {
        NamespacedKey key;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        NamespacedKey namespacedKey = key = data.contains(":") ? NamespacedKey.fromString((String)data) : NamespacedKey.minecraft((String)data.toLowerCase(Locale.ROOT));
        if (key == null) {
            throw new IllegalArgumentException("Invalid biome key: " + data);
        }
        try {
            return (Biome)Registry.BIOME.getOrThrow(key);
        }
        catch (NoSuchMethodError error) {
            return Biome.valueOf((String)data);
        }
    }

    @Override
    public String rightToLeft(@NonNull Biome data, @NonNull SerdesContext serdesContext) {
        NamespacedKey key;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        try {
            key = data.getKeyOrThrow();
        }
        catch (NoSuchMethodError error) {
            return data.name();
        }
        if (key.getNamespace().equals("minecraft")) {
            return key.getKey().toUpperCase(Locale.ROOT);
        }
        return String.valueOf(key);
    }
}

