/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.listener;

import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.GardenRegistry;
import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.persist.GardenPlantDataType;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.GardenPlant;
import dev.jsinco.brewery.garden.plant.PlantType;
import dev.jsinco.brewery.garden.plant.Seeds;
import dev.jsinco.brewery.garden.utility.WorldUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Skull;
import org.bukkit.block.data.type.WallSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockEventListener
implements Listener {
    private final PlantRegistry gardenRegistry;
    private static final Random RANDOM = new Random();
    private final GardenPlantDataType gardenPlantDataType;
    private BreweryGardenConfig config = Garden.getInstance().getPluginConfiguration();
    private static final List<BlockFace> FRUIT_FACES = List.of(BlockFace.UP, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST);

    public BlockEventListener(PlantRegistry gardenRegistry, GardenPlantDataType gardenPlantDataType) {
        this.gardenRegistry = gardenRegistry;
        this.gardenPlantDataType = gardenPlantDataType;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onLeafDecay(LeavesDecayEvent event) {
        if (WorldUtil.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        GardenPlant gardenPlant = this.gardenRegistry.getByLocation(event.getBlock());
        if (gardenPlant != null) {
            event.setCancelled(true);
        }
        this.checkSurroundingFruits(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (WorldUtil.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        Block block = event.getBlock();
        if (this.config.getValidSeedDropBlocks().contains(block.getType()) && RANDOM.nextInt(100) <= this.config.getSeedSpawnChance()) {
            List<PlantType> types = List.copyOf(GardenRegistry.PLANT_TYPE.values());
            PlantType chosen = types.get(RANDOM.nextInt(types.size()));
            ItemStack seeds = chosen.newSeeds().newItem(1);
            block.getWorld().dropItem(block.getLocation().toCenterLocation(), seeds);
        }
        this.checkFruit(block);
        GardenPlant gardenPlant = this.gardenRegistry.getByLocation(block);
        if (gardenPlant == null) {
            return;
        }
        this.checkAlive(gardenPlant);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        this.onMultiBlockDestroy(event.blockList());
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        this.onMultiBlockDestroy(event.blockList());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.onMultiBlockDestroy(event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.onMultiBlockDestroy(event.getBlocks());
    }

    private void onMultiBlockDestroy(Collection<Block> blocks) {
        Set<GardenPlant> plants = blocks.stream().map(this.gardenRegistry::getByLocation).filter(Objects::nonNull).collect(Collectors.toSet());
        plants.forEach(this::checkAlive);
        blocks.forEach(this::checkFruit);
    }

    private void checkAlive(GardenPlant gardenPlant) {
        Bukkit.getScheduler().runTask((Plugin)Garden.getInstance(), () -> {
            if (gardenPlant.isAlive()) {
                return;
            }
            this.gardenRegistry.unregisterPlant(gardenPlant);
            this.gardenPlantDataType.remove(gardenPlant);
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (Fruit.isFruit(event.getItemInHand())) {
            event.setCancelled(true);
            return;
        }
        if (WorldUtil.isBlacklistedWorld(event.getBlock().getLocation())) {
            return;
        }
        if (Seeds.isSeeds(event.getItemInHand())) {
            PlantType plantType = Seeds.getSeeds(event.getItemInHand()).plantType();
            GardenPlant gardenPlant = new GardenPlant(plantType, event.getBlock().getLocation());
            gardenPlant.getStructure().paste();
            this.gardenRegistry.registerPlant(gardenPlant);
            this.gardenPlantDataType.insert(gardenPlant);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (Garden.getGardenRegistry().getByLocation(event.getLocation().getBlock()) != null) {
            event.setCancelled(true);
        }
    }

    private void checkFruit(Block block) {
        if (Fruit.getPlantType(block) == null) {
            return;
        }
        block.setType(Material.AIR);
    }

    private void checkSurroundingFruits(Block block) {
        for (BlockFace blockFace : FRUIT_FACES) {
            WallSkull wallSkull;
            BlockData blockData;
            Block possibleFruit = block.getRelative(blockFace);
            PlantType plantType = Fruit.getPlantType(possibleFruit);
            if (plantType == null || possibleFruit.getBlockData() instanceof Skull && blockFace != BlockFace.UP || (blockData = possibleFruit.getBlockData()) instanceof WallSkull && blockFace != (wallSkull = (WallSkull)blockData).getFacing()) continue;
            possibleFruit.setType(Material.AIR);
            possibleFruit.getWorld().dropItem(possibleFruit.getLocation().toCenterLocation(), plantType.newFruit().newItem(1));
        }
    }
}

