/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.plant;

import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.persist.GardenPlantDataType;
import dev.jsinco.brewery.garden.plant.GardenPlant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class GrowthManager {
    private final PlantRegistry registry;
    private final Map<UUID, Long> growths = new HashMap<UUID, Long>();
    private static final Random RANDOM = new Random();
    private final GardenPlantDataType dataType;

    public GrowthManager(PlantRegistry registry, GardenPlantDataType dataType) {
        this.registry = registry;
        this.dataType = dataType;
    }

    public void tick() {
        for (GardenPlant plant : List.copyOf(this.registry.getPlants())) {
            if (plant.isFullyGrown()) {
                if (RANDOM.nextDouble() > 1.0 - Math.pow(0.5, 400.0 / (double)plant.getType().growthTime())) continue;
                if (plant.hasBloomed()) {
                    plant.placeFruits();
                    continue;
                }
                plant.bloom();
                continue;
            }
            double probability = 1.0 - Math.pow(0.5, 200.0 / (double)plant.getType().growthTime());
            if (!(RANDOM.nextDouble() < probability)) continue;
            plant.incrementGrowthStage(1, this.registry, this.dataType);
        }
    }
}

