/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.plant;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.Schematic;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.SchematicReadException;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.SchematicReader;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.FruitPlacement;
import dev.jsinco.brewery.garden.plant.Seeds;
import dev.jsinco.brewery.garden.structure.PlantStructure;
import dev.jsinco.brewery.garden.utility.FileUtil;
import dev.jsinco.brewery.garden.utility.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Vector3i;

public final class PlantType
extends Record
implements Keyed {
    private final String displayName;
    private final String skinBase64;
    private final int stages;
    private final Map<String, List<Schematic>> structures;
    private final NamespacedKey key;
    private final int growthTime;
    private final FruitPlacement fruitPlacement;
    private final Material seedMaterial;
    private static final UUID CONSTANT_UUID = UUID.fromString("f714a407-f7c9-425c-958d-c9914aeac05c");
    private static final List<Matrix3d> ALLOWED_TRANSFORMATIONS = PlantType.compileAllowedTransformations();
    private static final Random RANDOM = new Random();

    public PlantType(String displayName, String skinBase64, int stages, Map<String, List<Schematic>> structures, NamespacedKey key, int growthTime, FruitPlacement fruitPlacement, Material seedMaterial) {
        this.displayName = displayName;
        this.skinBase64 = skinBase64;
        this.stages = stages;
        this.structures = structures;
        this.key = key;
        this.growthTime = growthTime;
        this.fruitPlacement = fruitPlacement;
        this.seedMaterial = seedMaterial;
    }

    private static List<Matrix3d> compileAllowedTransformations() {
        int i;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Matrix3d identity = new Matrix3d();
        for (i = 0; i < 4; ++i) {
            builder.add((Object)PlantType.round(identity.rotateY(1.5707963267948966 * (double)i, new Matrix3d())));
        }
        identity.negateZ();
        for (i = 0; i < 4; ++i) {
            builder.add((Object)PlantType.round(identity.rotateY(1.5707963267948966 * (double)i, new Matrix3d())));
        }
        return builder.build();
    }

    private static Matrix3d round(Matrix3d input) {
        double[] array = input.get(new double[9]);
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.round(array[i]);
        }
        return new Matrix3d(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]);
    }

    public PlayerProfile getPlayerProfile() {
        PlayerProfile profile = Bukkit.createProfile((UUID)CONSTANT_UUID);
        profile.getProperties().add(new ProfileProperty("textures", this.skinBase64));
        return profile;
    }

    public PlantStructure newStructure(Location bottomLocation, int age, String track) {
        Schematic schematic = (Schematic)this.structures.getOrDefault(track, List.of()).get(age);
        Matrix3d transformation = ALLOWED_TRANSFORMATIONS.get(RANDOM.nextInt(ALLOWED_TRANSFORMATIONS.size()));
        Vector3i size = schematic.size(transformation);
        Vector3i offset = new Vector3i(size.x() / 2, 0, size.z() / 2);
        return new PlantStructure(schematic, bottomLocation.getBlockX(), bottomLocation.getBlockY(), bottomLocation.getBlockZ(), transformation, bottomLocation.getWorld().getUID(), offset);
    }

    public static List<PlantType> readPlantTypes() {
        File plants = new File(Garden.getInstance().getDataFolder(), "plants");
        if (!plants.exists()) {
            return List.of();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (File file : plants.listFiles()) {
            PlantType.readPlantType(file.getName().replace(".json", ""), FileUtil.readJsonFromFile(file)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    private static Optional<PlantType> readPlantType(String name, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String displayName = jsonObject.get("display_name").getAsString();
        String skinBase64 = jsonObject.get("texture_base64").getAsString();
        int growthStages = jsonObject.get("growth_stages").getAsInt();
        int growthTime = TimeUtil.parseTime(jsonObject.get("approximate_growth_time").getAsString());
        FruitPlacement fruitPlacement = FruitPlacement.valueOf(jsonObject.get("fruit_placement").getAsString().toUpperCase(Locale.ROOT));
        try {
            return Optional.of(new PlantType(displayName, skinBase64, growthStages, PlantType.findStructures(name, growthStages), new NamespacedKey("garden", name), growthTime, fruitPlacement, (Material)Registry.MATERIAL.get(NamespacedKey.fromString((String)jsonObject.get("seed_material").getAsString()))));
        }
        catch (SchematicReadException e) {
            Logger.getLogger("Garden").warning("Could not read plant type, outdated version: " + name);
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static Map<String, List<Schematic>> findStructures(String name, int growthStages) {
        JsonArray tracks = FileUtil.readJsonFromFile("structures/" + name + "/tracks.json").getAsJsonArray();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JsonElement typeJson : tracks) {
            String track = typeJson.getAsString();
            ImmutableList.Builder schematics = new ImmutableList.Builder();
            for (int i = 0; i < growthStages; ++i) {
                try (FileInputStream inputStream = new FileInputStream(new File(Garden.getInstance().getDataFolder(), "/structures/" + name + "/" + track + "_" + i + ".schem"));){
                    schematics.add((Object)new SchematicReader().read(inputStream));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.put((Object)track, (Object)schematics.build());
        }
        return builder.build();
    }

    public String getRandomTrack() {
        ArrayList<String> tracks = new ArrayList<String>(this.structures.keySet());
        return (String)tracks.get(RANDOM.nextInt(tracks.size()));
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key();
    }

    public Seeds newSeeds() {
        return new Seeds(this.key().getKey() + "_seeds", this);
    }

    public Fruit newFruit() {
        return new Fruit(this.key().getKey() + "_fruit", this);
    }

    public PlantStructure getStructure(Location origin, int age, String track, Matrix3d transformation) {
        Schematic schematic = this.structures.get(track).get(age);
        Vector3i size = schematic.size(transformation);
        Vector3i offset = new Vector3i(size.x() / 2, 0, size.z() / 2);
        return new PlantStructure(schematic, origin.getBlockX(), origin.getBlockY(), origin.getBlockZ(), transformation, origin.getWorld().getUID(), offset);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlantType.class, "displayName;skinBase64;stages;structures;key;growthTime;fruitPlacement;seedMaterial", "displayName", "skinBase64", "stages", "structures", "key", "growthTime", "fruitPlacement", "seedMaterial"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlantType.class, "displayName;skinBase64;stages;structures;key;growthTime;fruitPlacement;seedMaterial", "displayName", "skinBase64", "stages", "structures", "key", "growthTime", "fruitPlacement", "seedMaterial"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlantType.class, "displayName;skinBase64;stages;structures;key;growthTime;fruitPlacement;seedMaterial", "displayName", "skinBase64", "stages", "structures", "key", "growthTime", "fruitPlacement", "seedMaterial"}, this, o);
    }

    public String displayName() {
        return this.displayName;
    }

    public String skinBase64() {
        return this.skinBase64;
    }

    public int stages() {
        return this.stages;
    }

    public Map<String, List<Schematic>> structures() {
        return this.structures;
    }

    public NamespacedKey key() {
        return this.key;
    }

    public int growthTime() {
        return this.growthTime;
    }

    public FruitPlacement fruitPlacement() {
        return this.fruitPlacement;
    }

    public Material seedMaterial() {
        return this.seedMaterial;
    }
}

