/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.plant;

import dev.jsinco.brewery.garden.GardenRegistry;
import dev.jsinco.brewery.garden.plant.PlantItem;
import dev.jsinco.brewery.garden.plant.PlantType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public record Seeds(String simpleName, PlantType plantType) implements PlantItem
{
    public static boolean isSeeds(ItemStack item) {
        PersistentDataContainerView persistentDataContainer = item.getPersistentDataContainer();
        return persistentDataContainer.has(ITEM_TYPE_KEY) && ((String)persistentDataContainer.get(ITEM_TYPE_KEY, PersistentDataType.STRING)).equals(PlantItem.GardenItemType.SEEDS.name());
    }

    @Nullable
    public static Seeds getSeeds(ItemStack item) {
        PersistentDataContainerView containerView = item.getPersistentDataContainer();
        if (!(containerView.has(ITEM_TYPE_KEY) && containerView.has(PLANT_TYPE_KEY) && ((String)containerView.get(ITEM_TYPE_KEY, PersistentDataType.STRING)).equals(PlantItem.GardenItemType.SEEDS.name()))) {
            return null;
        }
        PlantType type = GardenRegistry.PLANT_TYPE.get(NamespacedKey.fromString((String)((String)containerView.get(PLANT_TYPE_KEY, PersistentDataType.STRING))));
        return type.newSeeds();
    }

    @Override
    public ItemStack newItem(int amount) {
        ItemStack item = new ItemStack(this.plantType.seedMaterial(), amount);
        item.setData(DataComponentTypes.ITEM_NAME, (Object)MiniMessage.miniMessage().deserialize((Object)this.plantType.displayName()));
        ItemMeta meta = item.getItemMeta();
        meta.lore(List.of((TextComponent)Component.text((String)"Rough seeds").color((TextColor)NamedTextColor.DARK_GRAY)));
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(ITEM_TYPE_KEY, PersistentDataType.STRING, (Object)this.itemType().name());
        container.set(PLANT_TYPE_KEY, PersistentDataType.STRING, (Object)this.plantType().key().toString());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public PlantItem.GardenItemType itemType() {
        return PlantItem.GardenItemType.SEEDS;
    }
}

