/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden;

import dev.jsinco.brewery.garden.plant.GardenPlant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantRegistry {
    private final Map<UUID, Map<BlockVector, GardenPlant>> gardenPlants = new HashMap<UUID, Map<BlockVector, GardenPlant>>();
    private final Map<UUID, GardenPlant> gardenPlantIds = new HashMap<UUID, GardenPlant>();

    @Nullable
    public GardenPlant getByID(UUID id) {
        return this.gardenPlantIds.get(id);
    }

    @Nullable
    public GardenPlant getByLocation(Block block) {
        World world = block.getWorld();
        BlockVector position = block.getLocation().toVector().toBlockVector();
        return (GardenPlant)this.gardenPlants.computeIfAbsent(world.getUID(), ignored -> new HashMap()).get(position);
    }

    public void registerPlant(GardenPlant plant) {
        UUID worldUuid = plant.getStructure().worldUuid();
        for (Location location : plant.getStructure().locations()) {
            this.gardenPlants.computeIfAbsent(worldUuid, ignored -> new HashMap()).put(location.toVector().toBlockVector(), plant);
        }
        this.gardenPlantIds.put(plant.getId(), plant);
    }

    public void unregisterPlant(GardenPlant plant) {
        this.gardenPlantIds.remove(plant.getId());
        UUID worldUuid = plant.getStructure().worldUuid();
        for (Location location : plant.getStructure().locations()) {
            this.gardenPlants.computeIfAbsent(worldUuid, ignored -> new HashMap()).remove(location.toVector().toBlockVector());
        }
    }

    public void unregisterWorld(@NotNull World world) {
        this.gardenPlants.remove(world.getUID());
        for (GardenPlant gardenPlant : List.copyOf(this.gardenPlantIds.values())) {
            if (gardenPlant.getStructure().origin().getWorld() != world) continue;
            this.gardenPlantIds.remove(gardenPlant.getId());
        }
    }

    public Collection<GardenPlant> getPlants() {
        return this.gardenPlantIds.values();
    }

    public void clear() {
        this.gardenPlants.clear();
        this.gardenPlantIds.clear();
    }
}

