/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands.subcomands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.plant.GardenPlant;
import dev.jsinco.brewery.garden.utility.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlantCommand {
    private static final SimpleCommandExceptionType ERROR_ILLEGAL_SENDER = new SimpleCommandExceptionType(() -> "You have to be a player to use this command!");
    private static final SimpleCommandExceptionType ERROR_NO_PLANT_FOUND = new SimpleCommandExceptionType(() -> "Could not find a garden plant!");

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"plant").then(PlantCommand.infoCommand())).then(PlantCommand.setAgeCommand())).then(PlantCommand.growFruitsCommand())).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("garden.command.plant"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> growFruitsCommand() {
        return Commands.literal((String)"growfruits").executes(commandContext -> {
            CommandSender patt0$temp = ((CommandSourceStack)commandContext.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                throw ERROR_ILLEGAL_SENDER.create();
            }
            Player player = (Player)patt0$temp;
            GardenPlant gardenPlant = PlantCommand.getPlant(player, 32);
            gardenPlant.bloom();
            gardenPlant.placeFruits();
            return 1;
        });
    }

    private static GardenPlant getPlant(Player player, int distance) throws CommandSyntaxException {
        Block block = player.getTargetBlockExact(distance);
        if (block == null) {
            throw ERROR_NO_PLANT_FOUND.create();
        }
        PlantRegistry gardenRegistry = Garden.getGardenRegistry();
        GardenPlant gardenPlant = gardenRegistry.getByLocation(block);
        if (gardenPlant == null) {
            throw ERROR_NO_PLANT_FOUND.create();
        }
        return gardenPlant;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> infoCommand() {
        return Commands.literal((String)"info").executes(context -> {
            CommandSender patt0$temp = ((CommandSourceStack)context.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                throw ERROR_ILLEGAL_SENDER.create();
            }
            Player player = (Player)patt0$temp;
            PlantCommand.sendPlantMessage(player, 32);
            return 1;
        });
    }

    private static void sendPlantMessage(Player player, int maxDistance) throws CommandSyntaxException {
        Block block = player.getTargetBlockExact(maxDistance);
        if (block == null) {
            throw ERROR_NO_PLANT_FOUND.create();
        }
        MessageUtil.sendMessage((CommandSender)player, "Found a GardenPlant: " + String.valueOf(PlantCommand.getPlant(player, 32)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> setAgeCommand() {
        return Commands.literal((String)"setage").then(Commands.argument((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Garden.getInstance().getPluginConfiguration().getFullyGrown())).executes(context -> {
            CommandSender patt0$temp = ((CommandSourceStack)context.getSource()).getSender();
            if (!(patt0$temp instanceof Player)) {
                throw ERROR_ILLEGAL_SENDER.create();
            }
            Player player = (Player)patt0$temp;
            GardenPlant gardenPlant = PlantCommand.getPlant(player, 32);
            gardenPlant.setGrowthStage((Integer)context.getArgument("stage", Integer.class), Garden.getGardenRegistry(), Garden.getInstance().getGardenPlantDataType());
            return 1;
        }));
    }
}

