/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.configuration;

import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.annotation.Header;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Tag;

@Header(value={"Welcome to the configuration file for the Garden addon!", "The settings below is all you're able to customize. If you'd like to request a feature", "or report a bug, join our Discord or make an issue on our Github! https://brewery.lumamc.net/", "To add a BreweryGarden item (plant or seeds), use 'garden:berry' or 'garden:berry_seeds'."})
public class BreweryGardenConfig
extends OkaeriConfig {
    @Comment(value={"How likely it is for a seed to spawn from a broken 'validSeedDropBlocks' block.", "Use an integer from 1 to 100."})
    private int seedSpawnChance = 15;
    @Comment(value={"The integer which determines if a plant is fully grown (has a plant sprouted on it).", "A plant's growth stage has an 80% chance to increase by '1' every 5 minutes. Making '4' equal one full Minecraft day, or 20 minutes."})
    private int fullyGrown = 4;
    @Comment(value={"A list of materials which a seed may drop from."})
    private List<Material> validSeedDropBlocks = List.of(Material.SHORT_GRASS, Material.TALL_GRASS);
    @Comment(value={"A list of materials which a seed may be planted on."})
    private List<Material> plantableBlocks = List.of(Material.GRASS_BLOCK, Material.DIRT, Material.COARSE_DIRT, Material.PODZOL);
    @Comment(value={"A list of worlds where the BreweryGarden addon is disabled."})
    private List<String> blacklistedWorlds = List.of("resource", "resource_nether");
    @Comment(value={"A list of tags of materials generated through Garden that will drop when broken"})
    private List<Tag<Material>> dropsDefaultItems = List.of(Tag.LOGS);
    @Comment(value={"A map of tags of materials generated through Garden with custom drops"})
    private Map<Tag<Material>, Material> dropOverride = new ImmutableMap.Builder().put((Object)Tag.WOODEN_STAIRS, (Object)Material.STICK).put((Object)Tag.WOODEN_TRAPDOORS, (Object)Material.STICK).build();

    public int getSeedSpawnChance() {
        return this.seedSpawnChance;
    }

    public int getFullyGrown() {
        return this.fullyGrown;
    }

    public List<Material> getValidSeedDropBlocks() {
        return this.validSeedDropBlocks;
    }

    public List<Material> getPlantableBlocks() {
        return this.plantableBlocks;
    }

    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    public List<Tag<Material>> getDropsDefaultItems() {
        return this.dropsDefaultItems;
    }

    public Map<Tag<Material>, Material> getDropOverride() {
        return this.dropOverride;
    }
}

