/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.integration;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.integration.Integration;
import dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.api.integration.ItemIntegration;
import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.MutableGardenRegistry;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.PlantItem;
import dev.jsinco.brewery.garden.plant.PlantType;
import dev.jsinco.brewery.garden.plant.Seeds;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Nullable;

public final class TBPGardenIntegration
implements ItemIntegration {
    public Optional<ItemStack> createItem(String key) {
        return this.get(key).map(PlantItem::newItem);
    }

    public boolean isIngredient(String key) {
        return this.get(key).isPresent();
    }

    @Nullable
    public Component displayName(String key) {
        return this.get(key).map(PlantItem::plantType).map(PlantType::displayName).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)).map(component -> component.color(null)).orElse(null);
    }

    private Optional<PlantItem> get(String key) {
        if (!key.contains("_seeds") && !key.contains("_fruit") || !Key.parseableValue((String)key)) {
            return Optional.empty();
        }
        String plantTypeKey = key.replaceAll("_seeds|_fruit", "");
        return Optional.ofNullable(Garden.key(plantTypeKey)).flatMap(plant -> Optional.ofNullable(MutableGardenRegistry.plantType.get((NamespacedKey)plant))).map(type -> key.contains("_seeds") ? type.newSeeds() : type.newFruit());
    }

    @Nullable
    public String getItemId(ItemStack itemStack) {
        if (Fruit.isFruit(itemStack)) {
            return Fruit.getFruit(itemStack).simpleName();
        }
        if (Seeds.isSeeds(itemStack)) {
            return Seeds.getSeeds(itemStack).simpleName();
        }
        return null;
    }

    public CompletableFuture<Void> initialized() {
        return CompletableFuture.completedFuture(null);
    }

    public String getId() {
        return "garden";
    }

    public boolean isEnabled() {
        return true;
    }

    public CompletableFuture<Optional<Ingredient>> createIngredient(String id) {
        if (!((String)id).contains("_fruit") && !((String)id).contains("_seeds")) {
            id = (String)id + "_fruit";
        }
        return super.createIngredient((String)id);
    }

    public static void loadIfPossible() {
        try {
            if (!Bukkit.getServicesManager().isProvidedFor(TheBrewingProjectApi.class)) {
                return;
            }
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(TheBrewingProjectApi.class);
            if (provider != null) {
                ((TheBrewingProjectApi)provider.getProvider()).getIntegrationManager().register(IntegrationTypes.ITEM, (Integration)new TBPGardenIntegration());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

