/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.BlockPosition;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.BlockUtilAPI;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.event.BlockDisableDropEvent;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.database.DatabaseInterface;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.BlockEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.BlockGrowEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.EntityEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.ExplodeEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.PistonEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener.WorldEventListener;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util.BlockHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Listener;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BlockUtil
implements BlockUtilAPI {
    private final DatabaseInterface databaseInterface;
    private final Map<UUID, Set<BlockPosition>> trackedBlocks = new HashMap<UUID, Set<BlockPosition>>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Consumer<BlockDisableDropEvent> dropEventHandler;

    public BlockUtil(DatabaseInterface databaseInterface, Consumer<BlockDisableDropEvent> dropEventHandler) {
        this.databaseInterface = databaseInterface;
        this.dropEventHandler = dropEventHandler;
    }

    public void registerListeners(Plugin plugin) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new BlockEventListener(this), plugin);
        pluginManager.registerEvents((Listener)new PistonEventListener(this), plugin);
        pluginManager.registerEvents((Listener)new ExplodeEventListener(this), plugin);
        pluginManager.registerEvents((Listener)new EntityEventListener(this), plugin);
        pluginManager.registerEvents((Listener)new BlockGrowEventListener(this), plugin);
        pluginManager.registerEvents((Listener)new WorldEventListener(this), plugin);
    }

    @Override
    public void disableItemDrops(Block block) {
        List<Block> blockStructure = BlockHelper.getBlockStructure(block);
        UUID worldUuid = block.getWorld().getUID();
        blockStructure.forEach(blockInStructure -> {
            BlockPosition blockLocation = BlockPosition.from(blockInStructure.getLocation());
            this.blockItemDropsDisabled(blockLocation, worldUuid).thenAcceptAsync(itemDropsDisabled -> {
                if (itemDropsDisabled.booleanValue()) {
                    return;
                }
                this.trackedBlocks.get(worldUuid).add(blockLocation);
                this.databaseInterface.trackBlock(blockLocation, worldUuid);
            }, (Executor)this.executor);
        });
    }

    @Override
    public void enableItemDrops(Block block) {
        List<Block> blockStructure = BlockHelper.getBlockStructure(block);
        UUID worldUuid = block.getWorld().getUID();
        blockStructure.forEach(blockInStructure -> {
            BlockPosition blockLocation = BlockPosition.from(blockInStructure.getLocation());
            this.blockItemDropsDisabled(blockLocation, worldUuid).thenAcceptAsync(itemDropsDisabled -> {
                if (!itemDropsDisabled.booleanValue()) {
                    return;
                }
                this.databaseInterface.freeBlock(blockLocation, worldUuid);
                this.trackedBlocks.get(worldUuid).remove(blockLocation);
            }, (Executor)this.executor);
        });
    }

    @Override
    public CompletableFuture<Boolean> blockItemDropsDisabled(BlockPosition block, UUID worldUuid) {
        return CompletableFuture.supplyAsync(() -> this.trackedBlocks.computeIfAbsent(worldUuid, ignored -> new HashSet()).contains(block), this.executor);
    }

    @Override
    public void moveBlock(Block from, BlockVector delta) {
        BlockPosition pos = BlockPosition.from(from.getLocation());
        UUID worldUuid = from.getWorld().getUID();
        this.blockItemDropsDisabled(pos, worldUuid).thenAcceptAsync(itemDropsDisable -> {
            if (!itemDropsDisable.booleanValue()) {
                return;
            }
            this.databaseInterface.moveBlock(pos, delta, worldUuid);
            Set<BlockPosition> tracked = this.trackedBlocks.get(worldUuid);
            tracked.remove(pos);
            tracked.add(pos.add(delta));
        }, (Executor)this.executor);
    }

    public void onWorldLoad(UUID worldUuid) {
        this.databaseInterface.getAllBlocks(worldUuid).thenAcceptAsync(tracked -> this.trackedBlocks.put(worldUuid, (Set<BlockPosition>)tracked), (Executor)this.executor);
    }

    public void onWorldUnload(UUID worldUuid) {
        this.executor.execute(() -> this.trackedBlocks.remove(worldUuid));
    }

    public void loadWorlds() {
        this.executor.execute(() -> Bukkit.getWorlds().stream().map(WorldInfo::getUID).forEach(worldUuid -> this.trackedBlocks.put((UUID)worldUuid, this.databaseInterface.getAllBlocks((UUID)worldUuid).join())));
    }

    public BlockDisableDropEvent newDisable(BlockState block) {
        BlockDisableDropEvent output = new BlockDisableDropEvent(block);
        this.dropEventHandler.accept(output);
        return output;
    }
}

