/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.BlockPosition;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.event.BlockDisableDropEvent;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.database.DatabaseInterface;
import java.sql.Connection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public interface BlockUtilAPI {
    public void disableItemDrops(Block var1);

    public void enableItemDrops(Block var1);

    default public boolean blockItemDropsDisabled(Block block) {
        return this.blockItemDropsDisabled(BlockPosition.from(block.getLocation()), block.getWorld().getUID()).join();
    }

    public CompletableFuture<Boolean> blockItemDropsDisabled(BlockPosition var1, UUID var2);

    public void moveBlock(Block var1, BlockVector var2);

    public static class Builder {
        private Supplier<Connection> connectionSupplier;
        private String prefix = "";
        private Consumer<BlockDisableDropEvent> dropEventHandler = itemStack -> {};
        private Plugin owner;

        public Builder withConnectionSupplier(Supplier<Connection> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
            return this;
        }

        public Builder withDbPrefix(String prefix) {
            Preconditions.checkNotNull((Object)prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder withDropEventHandler(Consumer<BlockDisableDropEvent> dropEventHandler) {
            Preconditions.checkNotNull(dropEventHandler);
            this.dropEventHandler = dropEventHandler;
            return this;
        }

        public Builder withPluginOwner(Plugin owner) {
            this.owner = owner;
            return this;
        }

        public BlockUtilAPI build() {
            Preconditions.checkNotNull(this.connectionSupplier);
            DatabaseInterface databaseInterface = new DatabaseInterface(this.connectionSupplier, this.prefix);
            databaseInterface.init();
            BlockUtil built = new BlockUtil(databaseInterface, this.dropEventHandler);
            built.registerListeners(this.owner);
            built.loadWorlds();
            return built;
        }
    }
}

