/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.event.BlockDisableDropEvent;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util.BlockHelper;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.util.BlockVector;

public class BlockEventListener
implements Listener {
    private final BlockUtil api;

    public BlockEventListener(BlockUtil api) {
        this.api = api;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onBlockDropItem(BlockDropItemEvent event) {
        if (!this.api.blockItemDropsDisabled(event.getBlock())) {
            return;
        }
        BlockDisableDropEvent blockDisableDropEvent = this.api.newDisable(event.getBlockState());
        if (blockDisableDropEvent.disableDrops()) {
            List items = event.getItems();
            items.clear();
            Location location = event.getBlock().getLocation().toCenterLocation();
            blockDisableDropEvent.getDropOverride().stream().map(itemStack -> {
                Item item = (Item)event.getBlock().getWorld().createEntity(location, Item.class);
                item.setItemStack(itemStack);
                return item;
            }).forEach(items::add);
        }
        this.api.enableItemDrops(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockBreak(BlockBreakEvent event) {
        if (event.isDropItems()) {
            return;
        }
        this.api.enableItemDrops(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockBurn(BlockBurnEvent event) {
        this.api.enableItemDrops(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockFade(BlockFadeEvent event) {
        this.api.enableItemDrops(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockForm(BlockFormEvent event) {
        this.api.enableItemDrops(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onBlockFromTo(BlockFromToEvent event) {
        if (event.getBlock().getType() == Material.DRAGON_EGG) {
            BlockVector delta = event.getToBlock().getLocation().subtract(event.getBlock().getLocation()).toVector().toBlockVector();
            this.api.moveBlock(event.getBlock(), delta);
            return;
        }
        if (this.api.blockItemDropsDisabled(event.getToBlock())) {
            event.setCancelled(true);
            BlockHelper.breakBlock(event.getToBlock(), this.api);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onLeavesDecay(LeavesDecayEvent event) {
        if (this.api.blockItemDropsDisabled(event.getBlock())) {
            event.setCancelled(true);
            BlockHelper.breakBlock(event.getBlock(), this.api);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onBlockPhysicsEvent(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        if (block.getType().isAir()) {
            return;
        }
        if (block.getBlockData().isSupported(block) || !this.api.blockItemDropsDisabled(block)) {
            return;
        }
        BlockDisableDropEvent disableDropEvent = this.api.newDisable(event.getBlock().getState());
        if (!disableDropEvent.disableDrops()) {
            return;
        }
        event.setCancelled(true);
        World world = block.getWorld();
        Location location = block.getLocation().toCenterLocation();
        disableDropEvent.getDropOverride().stream().forEach(itemStack -> world.dropItemNaturally(location, itemStack));
        BlockHelper.breakBlock(block, this.api);
    }
}

