/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util.BlockHelper;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonEventListener
implements Listener {
    private final BlockUtil api;

    public PistonEventListener(BlockUtil api) {
        this.api = api;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.handlePistonEvent(event.getBlocks(), event.getDirection());
        if (this.api.blockItemDropsDisabled(event.getBlock())) {
            this.api.disableItemDrops(event.getBlock().getRelative(event.getDirection()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.handlePistonEvent(event.getBlocks(), event.getDirection());
        if (this.api.blockItemDropsDisabled(event.getBlock()) && event.getBlocks().isEmpty()) {
            this.api.enableItemDrops(event.getBlock().getRelative(event.getDirection().getOppositeFace()));
        }
    }

    private void handlePistonEvent(List<Block> blocks, BlockFace direction) {
        for (Block block : blocks) {
            if (this.willBreakOnPistonMove(blocks, block, direction)) {
                BlockHelper.breakBlockIfTracked(block, this.api);
                continue;
            }
            this.api.moveBlock(block, direction.getDirection().toBlockVector());
        }
    }

    private boolean willBreakOnPistonMove(List<Block> blocks, Block block, BlockFace direction) {
        if (block.getPistonMoveReaction() == PistonMoveReaction.BREAK) {
            return true;
        }
        Block blockDown = block.getRelative(BlockFace.DOWN);
        if (blocks.contains(blockDown)) {
            return this.willBreakOnPistonMove(blocks, blockDown, direction);
        }
        return !block.getBlockData().isSupported(block.getRelative(direction));
    }
}

