/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class BlockUtil {
    private static final Map<Vector3d, BlockFace> DIRECTION_TO_BLOCK_FACE_MAP = BlockUtil.compileFaces();
    private static final Map<Vector3d, Axis> DIRECTION_TO_AXIS_MAP = BlockUtil.compileAxis();

    private BlockUtil() {
    }

    public static BlockData transformBlockData(BlockData blockData, Matrix3d transformation) {
        BlockData copiedData = blockData.clone();
        if (copiedData instanceof Directional) {
            Directional directional = (Directional)copiedData;
            BlockFace newFacing = BlockUtil.transformBlockFace(directional.getFacing(), transformation);
            if (directional.getFaces().contains(newFacing)) {
                directional.setFacing(newFacing);
            }
        }
        if (copiedData instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)copiedData;
            HashSet<BlockFace> newFaces = new HashSet<BlockFace>();
            for (BlockFace face : multipleFacing.getFaces()) {
                newFaces.add(BlockUtil.transformBlockFace(face, transformation));
            }
            for (BlockFace allowedFace : multipleFacing.getAllowedFaces()) {
                multipleFacing.setFace(allowedFace, newFaces.contains(allowedFace));
            }
        }
        if (copiedData instanceof Orientable) {
            Orientable orientable = (Orientable)copiedData;
            Axis newAxis = BlockUtil.transformAxis(orientable.getAxis(), transformation);
            if (orientable.getAxes().contains(newAxis)) {
                orientable.setAxis(newAxis);
            }
        }
        return copiedData;
    }

    private static BlockFace transformBlockFace(BlockFace blockFace, Matrix3d transformation) {
        Vector direction = blockFace.getDirection();
        return BlockUtil.transform(new Vector3d(direction.getX(), direction.getY(), direction.getZ()), transformation, DIRECTION_TO_BLOCK_FACE_MAP);
    }

    private static Axis transformAxis(Axis axis, Matrix3d transformation) {
        if (axis == Axis.X) {
            return BlockUtil.transform(new Vector3d(1.0, 0.0, 0.0), transformation, DIRECTION_TO_AXIS_MAP);
        }
        if (axis == Axis.Y) {
            return BlockUtil.transform(new Vector3d(0.0, 1.0, 0.0), transformation, DIRECTION_TO_AXIS_MAP);
        }
        return BlockUtil.transform(new Vector3d(0.0, 0.0, 1.0), transformation, DIRECTION_TO_AXIS_MAP);
    }

    private static <T> T transform(Vector3d vector, Matrix3d transformation, Map<Vector3d, T> possibleOutcomes) {
        Vector3d transformed = transformation.transform(vector).normalize();
        @Nullable T output = possibleOutcomes.get(transformed);
        if (output != null) {
            return output;
        }
        double closest = Double.MAX_VALUE;
        for (Map.Entry<Vector3d, T> entry : possibleOutcomes.entrySet()) {
            double distance = entry.getKey().distance((Vector3dc)transformed);
            if (!(distance < closest)) continue;
            closest = distance;
            output = entry.getValue();
        }
        return output;
    }

    private static Map<Vector3d, BlockFace> compileFaces() {
        HashMap<Vector3d, BlockFace> output = new HashMap<Vector3d, BlockFace>();
        for (BlockFace blockFace : BlockFace.values()) {
            Vector direction = blockFace.getDirection();
            output.put(new Vector3d(direction.getX(), direction.getY(), direction.getZ()).normalize(), blockFace);
        }
        return output;
    }

    private static Map<Vector3d, Axis> compileAxis() {
        HashMap<Vector3d, Axis> output = new HashMap<Vector3d, Axis>();
        output.put(new Vector3d(1.0, 0.0, 0.0), Axis.X);
        output.put(new Vector3d(-1.0, 0.0, 0.0), Axis.X);
        output.put(new Vector3d(0.0, 1.0, 0.0), Axis.Y);
        output.put(new Vector3d(0.0, -1.0, 0.0), Axis.Y);
        output.put(new Vector3d(0.0, 0.0, 1.0), Axis.Z);
        output.put(new Vector3d(0.0, 0.0, -1.0), Axis.Z);
        return output;
    }
}

