/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.ReadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public record Schematic(Vector3i size, Vector3i offset, BlockData[] palette, byte[] blocks) {
    private final BlockData[] palette;
    private final byte[] blocks;
    private static final System.Logger logger = System.getLogger(Schematic.class.getName());

    public Schematic {
        palette = Arrays.copyOf(palette, palette.length);
        blocks = Arrays.copyOf(blocks, blocks.length);
    }

    public BlockData @NotNull [] palette() {
        return Arrays.copyOf(this.palette, this.palette.length);
    }

    public byte @NotNull [] blocks() {
        return Arrays.copyOf(this.blocks, this.blocks.length);
    }

    @NotNull
    public Vector3i size(@NotNull Matrix3d transformation) {
        return this.transform(this.size, transformation);
    }

    @NotNull
    public Vector3i offset(@NotNull Matrix3d transformation) {
        return this.transform(this.offset, transformation);
    }

    private Vector3i transform(Vector3i vector3i, Matrix3d transformation) {
        Vector3d transformed = transformation.transform(new Vector3d((Vector3ic)vector3i)).ceil();
        return new Vector3i((int)transformed.x, (int)transformed.y, (int)transformed.z);
    }

    public void apply(@NotNull Matrix3d transformation, @NotNull BiConsumer<Vector3i, BlockData> applicator) {
        ByteBuffer blocks = ByteBuffer.wrap(this.blocks);
        BlockData[] transformedPalette = (BlockData[])Arrays.stream(this.palette).map(blockData -> BlockUtil.transformBlockData(blockData, transformation)).toArray(BlockData[]::new);
        for (int y = 0; y < this.size().y(); ++y) {
            for (int z = 0; z < this.size().z(); ++z) {
                for (int x = 0; x < this.size().x(); ++x) {
                    BlockData block = transformedPalette[ReadUtils.readVarInt(blocks)];
                    if (block == null) {
                        logger.log(System.Logger.Level.WARNING, "Missing palette entry at {0}, {1}, {2}", x, y, z);
                        block = Material.AIR.createBlockData();
                    }
                    applicator.accept(this.transform(new Vector3i(x, y, z).add((Vector3ic)this.offset), transformation), block);
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schematic schematic = (Schematic)o;
        return this.size.equals((Object)schematic.size) && this.offset.equals((Object)schematic.offset) && Arrays.equals(this.palette, schematic.palette) && Arrays.equals(this.blocks, schematic.blocks);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.size, this.offset);
        result = 31 * result + Arrays.hashCode(this.palette);
        result = 31 * result + Arrays.hashCode(this.blocks);
        return result;
    }

    @Override
    public String toString() {
        return String.format("Schematic[size=%s, offset=%s, palette=%s, blocks=%s]", this.size, this.offset, Arrays.toString(this.palette), Arrays.toString(this.blocks));
    }
}

