/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.plant;

import com.google.common.collect.ImmutableSet;
import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.persist.GardenPlantDataType;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.PlantType;
import dev.jsinco.brewery.garden.structure.PlantStructure;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockType;

public class GardenPlant {
    private static final BreweryGardenConfig config = Garden.getInstance().getPluginConfiguration();
    private final UUID id;
    private final PlantType type;
    private PlantStructure structure;
    private final String track;
    private int age;
    private static final Random RANDOM = new Random();
    private boolean bloomed = false;
    private static final Set<Material> DECORATIVE_PLANT_BLOCKS = GardenPlant.compileDecorativePlantBlocks();

    private static Set<Material> compileDecorativePlantBlocks() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll((Iterable)Tag.BUTTONS.getValues());
        builder.addAll((Iterable)Tag.SLABS.getValues());
        builder.addAll((Iterable)Tag.TRAPDOORS.getValues());
        builder.add((Object[])new Material[]{Material.MOSS_CARPET, Material.PINK_PETALS});
        return builder.build();
    }

    public GardenPlant(PlantType type, Location location) {
        this.id = UUID.randomUUID();
        this.type = type;
        this.age = 0;
        this.track = type.getRandomTrack();
        this.structure = type.newStructure(location, this.age, this.track);
    }

    public boolean isFullyGrown() {
        return this.age >= this.type.stages() - 1;
    }

    public void incrementGrowthStage(int amount, PlantRegistry registry, GardenPlantDataType dataType) {
        this.setGrowthStage(this.age + amount, registry, dataType);
    }

    public void setGrowthStage(int growthStage, PlantRegistry registry, GardenPlantDataType dataType) {
        if (!this.structure.origin().isChunkLoaded()) {
            return;
        }
        this.structure.remove();
        PlantStructure newStructure = this.type.newStructure(this.structure.origin(), growthStage, this.track);
        if (!newStructure.locations(blockData -> !DECORATIVE_PLANT_BLOCKS.contains(blockData.getMaterial())).stream().map(Location::getBlock).map(Block::getType).allMatch(material -> material.isAir() || Tag.REPLACEABLE_BY_TREES.isTagged((Keyed)material))) {
            this.structure.paste();
            return;
        }
        this.age = growthStage;
        registry.unregisterPlant(this);
        newStructure.paste();
        this.structure = newStructure;
        registry.registerPlant(this);
        dataType.update(this);
    }

    public void bloom() {
        if (!this.structure.origin().isChunkLoaded()) {
            return;
        }
        if (this.structure.locations(blockData -> Tag.LEAVES.isTagged((Keyed)blockData.getMaterial())).stream().map(Location::getBlock).flatMap(block -> this.type.fruitPlacement().vectors().stream().map(arg_0 -> ((Block)block).getRelative(arg_0))).anyMatch(block -> Fruit.getPlantType(block) != null)) {
            return;
        }
        for (Location location : this.structure.locations(blockData -> Tag.LEAVES.isTagged((Keyed)blockData.getMaterial()))) {
            Block block2 = location.getBlock();
            if (!Tag.LEAVES.isTagged((Keyed)block2.getType()) || !RANDOM.nextBoolean()) continue;
            block2.setBlockData(BlockType.FLOWERING_AZALEA_LEAVES.createBlockData());
            this.bloomed = true;
        }
    }

    public void placeFruits() {
        if (!this.structure.origin().isChunkLoaded()) {
            return;
        }
        Fruit fruit = this.type.newFruit();
        for (Location location : this.structure.locations()) {
            List<BlockFace> relatives;
            Block block = location.getBlock();
            if (Material.FLOWERING_AZALEA_LEAVES != block.getType() || (relatives = this.type.fruitPlacement().vectors().stream().filter(relative -> block.getRelative(relative).getType().isAir()).toList()).isEmpty()) continue;
            BlockFace chosenRelative = relatives.get(RANDOM.nextInt(relatives.size()));
            fruit.placeFruit(block.getRelative(chosenRelative), chosenRelative);
        }
        this.structure.paste();
        this.bloomed = false;
    }

    public boolean hasBloomed() {
        return this.bloomed;
    }

    public boolean isAlive() {
        boolean hasLeaf = false;
        for (Location location : this.structure.locations()) {
            if (!Tag.LEAVES.isTagged((Keyed)location.getBlock().getType())) continue;
            hasLeaf = true;
        }
        return hasLeaf && !this.structure.origin().getBlock().getType().isAir();
    }

    public UUID getId() {
        return this.id;
    }

    public PlantType getType() {
        return this.type;
    }

    public PlantStructure getStructure() {
        return this.structure;
    }

    public String getTrack() {
        return this.track;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isBloomed() {
        return this.bloomed;
    }

    public String toString() {
        return "GardenPlant(id=" + String.valueOf(this.getId()) + ", type=" + String.valueOf(this.getType()) + ", structure=" + String.valueOf(this.getStructure()) + ", track=" + this.getTrack() + ", age=" + this.getAge() + ", bloomed=" + this.isBloomed() + ")";
    }

    public GardenPlant(UUID id, PlantType type, PlantStructure structure, String track, int age, boolean bloomed) {
        this.id = id;
        this.type = type;
        this.structure = structure;
        this.track = track;
        this.age = age;
        this.bloomed = bloomed;
    }
}

