/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.structure;

import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.Schematic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.joml.Matrix3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public record PlantStructure(Schematic schematic, int originX, int originY, int originZ, Matrix3d transformation, UUID worldUuid, Vector3i offset) {
    public List<Location> locations() {
        ArrayList<Location> locations = new ArrayList<Location>();
        World world = Bukkit.getWorld((UUID)this.worldUuid);
        this.schematic.apply(this.transformation, (vector3i, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            vector3i.sub((Vector3ic)this.offset);
            locations.add(new Location(world, (double)this.originX, (double)this.originY, (double)this.originZ).add((double)vector3i.x, (double)vector3i.y, (double)vector3i.z));
        });
        return locations;
    }

    public List<Location> locations(Predicate<BlockData> filter) {
        ArrayList<Location> locations = new ArrayList<Location>();
        World world = Bukkit.getWorld((UUID)this.worldUuid);
        this.schematic.apply(this.transformation, (vector3i, blockData) -> {
            if (blockData.getMaterial().isAir() || !filter.test((BlockData)blockData)) {
                return;
            }
            vector3i.sub((Vector3ic)this.offset);
            locations.add(new Location(world, (double)this.originX, (double)this.originY, (double)this.originZ).add((double)vector3i.x, (double)vector3i.y, (double)vector3i.z));
        });
        return locations;
    }

    public void paste() {
        World world = Bukkit.getWorld((UUID)this.worldUuid);
        this.schematic.apply(this.transformation, (vector3i, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            if (blockData instanceof Leaves) {
                Leaves leaves = (Leaves)blockData;
                leaves.setPersistent(false);
            }
            vector3i.sub((Vector3ic)this.offset);
            Location posToReplace = new Location(world, (double)this.originX, (double)this.originY, (double)this.originZ).add((double)vector3i.x, (double)vector3i.y, (double)vector3i.z);
            Material blockToReplaceType = posToReplace.getBlock().getType();
            if (!Tag.REPLACEABLE_BY_TREES.isTagged((Keyed)blockToReplaceType) && !blockToReplaceType.isAir()) {
                return;
            }
            world.setBlockData(posToReplace, blockData);
            Garden.getInstance().getBlockUtil().disableItemDrops(world.getBlockAt(posToReplace));
        });
    }

    public void remove() {
        World world = Bukkit.getWorld((UUID)this.worldUuid);
        this.schematic.apply(this.transformation, (vector3i, blockData) -> {
            if (blockData.getMaterial().isAir()) {
                return;
            }
            vector3i.sub((Vector3ic)this.offset);
            Location location = new Location(world, (double)this.originX, (double)this.originY, (double)this.originZ).add((double)vector3i.x, (double)vector3i.y, (double)vector3i.z);
            if (location.getBlock().getType() == blockData.getMaterial()) {
                location.getBlock().setType(Material.AIR);
            }
            Garden.getInstance().getBlockUtil().enableItemDrops(world.getBlockAt(location));
        });
    }

    public Location origin() {
        return new Location(Bukkit.getWorld((UUID)this.worldUuid), (double)this.originX, (double)this.originY, (double)this.originZ);
    }
}

