/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden;

import com.dre.brewery.recipe.PluginItem;
import com.google.common.base.Preconditions;
import dev.jsinco.brewery.garden.GardenRegistry;
import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.commands.GardenCommand;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.configuration.SerdesGarden;
import dev.jsinco.brewery.garden.integration.BreweryGardenIngredient;
import dev.jsinco.brewery.garden.integration.TBPGardenIntegration;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.BlockUtilAPI;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.event.BlockDisableDropEvent;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.yaml.bukkit.YamlBukkitConfigurer;
import dev.jsinco.brewery.garden.lib.eu.okaeri.configs.yaml.bukkit.serdes.SerdesBukkit;
import dev.jsinco.brewery.garden.listener.BlockEventListener;
import dev.jsinco.brewery.garden.listener.EventListeners;
import dev.jsinco.brewery.garden.persist.Database;
import dev.jsinco.brewery.garden.persist.GardenPlantDataType;
import dev.jsinco.brewery.garden.plant.GardenPlant;
import dev.jsinco.brewery.garden.plant.GrowthManager;
import dev.jsinco.brewery.garden.plant.PlantType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Garden
extends JavaPlugin {
    private static Garden instance;
    private static PlantRegistry gardenRegistry;
    private BreweryGardenConfig pluginConfiguration;
    private Database database;
    private GardenPlantDataType gardenPlantDataType;
    private BlockUtilAPI blockUtil;
    private boolean loadSuccess = false;

    public void onLoad() {
        instance = this;
        this.savePlantResources();
        try {
            PluginItem.registerForConfig((String)this.getName(), BreweryGardenIngredient::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            TBPGardenIntegration.loadIfPossible();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.loadSuccess = true;
    }

    public void onEnable() {
        Preconditions.checkState((boolean)this.loadSuccess, (Object)"Failed on load, see logs.");
        this.database = new Database();
        try {
            this.database.init(this.getDataFolder());
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        gardenRegistry = new PlantRegistry();
        this.gardenPlantDataType = new GardenPlantDataType(this.database);
        this.blockUtil = new BlockUtilAPI.Builder().withConnectionSupplier(() -> {
            try {
                return this.database.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).withDropEventHandler(this::handleBlockDrops).withPluginOwner((Plugin)this).build();
        this.pluginConfiguration = this.compileConfig();
        for (World world : Bukkit.getWorlds()) {
            List<GardenPlant> gardenPlants = this.gardenPlantDataType.fetch(world).join();
            gardenPlants.forEach(gardenRegistry::registerPlant);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new EventListeners(gardenRegistry, this.gardenPlantDataType), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockEventListener(gardenRegistry, this.gardenPlantDataType), (Plugin)this);
        this.registerPlantRecipes();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, GardenCommand::register);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, new GrowthManager(gardenRegistry, this.gardenPlantDataType)::tick, 0L, 200L);
    }

    private void savePlantResources() {
        try (InputStream inputStream = Garden.class.getResourceAsStream("/plants.zip");){
            if (inputStream == null) {
                throw new IOException("Could not find internal resource: /plants.zip");
            }
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    ZipEntry current = entry;
                    if (current.isDirectory()) {
                        entry = zipInputStream.getNextEntry();
                        continue;
                    }
                    File destination = new File(this.getDataFolder(), current.getName());
                    if (destination.exists()) {
                        entry = zipInputStream.getNextEntry();
                        continue;
                    }
                    File destinationFolder = destination.getParentFile();
                    if (!destinationFolder.exists() && !destination.getParentFile().mkdirs()) {
                        throw new IOException("Could not make dirs at: " + String.valueOf(destinationFolder));
                    }
                    if (!destination.createNewFile()) {
                        throw new IOException("could not make file: " + String.valueOf(destination));
                    }
                    try (FileOutputStream outputStream = new FileOutputStream(destination);){
                        zipInputStream.transferTo(outputStream);
                    }
                    entry = zipInputStream.getNextEntry();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleBlockDrops(BlockDisableDropEvent blockDisableDropEvent) {
        Material material = blockDisableDropEvent.getBlock().getType();
        if (this.pluginConfiguration.getDropsDefaultItems().stream().anyMatch(tag -> tag.isTagged((Keyed)material))) {
            blockDisableDropEvent.setDisableDrops(false);
            return;
        }
        for (Map.Entry<Tag<Material>, Material> entry : this.pluginConfiguration.getDropOverride().entrySet()) {
            if (!entry.getKey().isTagged((Keyed)material)) continue;
            blockDisableDropEvent.setDropOverride(List.of(new ItemStack(entry.getValue())));
            return;
        }
    }

    public void reload() {
        this.pluginConfiguration = this.compileConfig();
    }

    private BreweryGardenConfig compileConfig() {
        return ConfigManager.create(BreweryGardenConfig.class, it -> {
            it.withConfigurer(new YamlBukkitConfigurer(), new SerdesBukkit(), new SerdesGarden());
            it.withBindFile(new File(this.getDataFolder(), "config.yml"));
            it.saveDefaults();
            it.load(true);
        });
    }

    private void registerPlantRecipes() {
        for (PlantType plantType : GardenRegistry.PLANT_TYPE.values()) {
            NamespacedKey namespacedKey = plantType.key();
            if (Bukkit.getRecipe((NamespacedKey)namespacedKey) != null) {
                Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            }
            ShapelessRecipe recipe = new ShapelessRecipe(namespacedKey, plantType.newSeeds().newItem(4));
            recipe.addIngredient(plantType.newFruit().newItem(1));
            Bukkit.addRecipe((Recipe)recipe);
        }
    }

    public static NamespacedKey key(String key) {
        if (!Key.parseableValue((String)key)) {
            return null;
        }
        return new NamespacedKey("garden", key);
    }

    public static Garden getInstance() {
        return instance;
    }

    public static PlantRegistry getGardenRegistry() {
        return gardenRegistry;
    }

    public BreweryGardenConfig getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public GardenPlantDataType getGardenPlantDataType() {
        return this.gardenPlantDataType;
    }

    public BlockUtilAPI getBlockUtil() {
        return this.blockUtil;
    }
}

