/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.commands.subcomands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jsinco.brewery.garden.commands.argument.PlantItemArgument;
import dev.jsinco.brewery.garden.plant.PlantItem;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand {
    private static final SimpleCommandExceptionType ERROR_ILLEGAL_SENDER = new SimpleCommandExceptionType(() -> "You have to specify a player to use this command!");

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)new PlantItemArgument()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(context -> {
            ItemStack itemStack = ((PlantItem)context.getArgument("item", PlantItem.class)).newItem((Integer)context.getArgument("amount", Integer.class));
            GiveCommand.giveSender(itemStack, (CommandSender)((List)((PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource())).getFirst());
            return 1;
        }))).executes(context -> {
            ItemStack itemStack = ((PlantItem)context.getArgument("item", PlantItem.class)).newItem((Integer)context.getArgument("amount", Integer.class));
            GiveCommand.giveSender(itemStack, ((CommandSourceStack)context.getSource()).getSender());
            return 1;
        }))).executes(context -> {
            ItemStack itemStack = ((PlantItem)context.getArgument("item", PlantItem.class)).newItem(1);
            GiveCommand.giveSender(itemStack, ((CommandSourceStack)context.getSource()).getSender());
            return 1;
        }))).requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("garden.command.give"));
    }

    private static void giveSender(ItemStack itemStack, CommandSender sender) throws CommandSyntaxException {
        if (!(sender instanceof Player)) {
            throw ERROR_ILLEGAL_SENDER.create();
        }
        Player player = (Player)sender;
        if (!player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
            player.getWorld().dropItem(player.getLocation(), itemStack);
        }
    }
}

