/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.listener;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util.BlockHelper;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class BlockGrowEventListener
implements Listener {
    private final BlockUtil api;

    public BlockGrowEventListener(BlockUtil api) {
        this.api = api;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockGrow(BlockGrowEvent event) {
        block6: {
            block5: {
                Block down;
                Material blockType = event.getNewState().getType();
                if ((blockType == Material.CACTUS || blockType == Material.SUGAR_CANE) && this.api.blockItemDropsDisabled(down = event.getBlock().getRelative(BlockFace.DOWN))) {
                    this.api.disableItemDrops(event.getBlock());
                }
                if (blockType == Material.PUMPKIN) break block5;
                if (blockType != Material.MELON) break block6;
            }
            if (BlockHelper.getAdjacentBlocks(event.getBlock()).stream().filter(block -> Tag.CROPS.isTagged((Keyed)block.getType())).anyMatch(this.api::blockItemDropsDisabled)) {
                this.api.disableItemDrops(event.getBlock());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onStructureGrow(StructureGrowEvent event) {
        if (this.api.blockItemDropsDisabled(event.getLocation().getBlock())) {
            event.getBlocks().stream().map(BlockState::getBlock).forEach(this.api::disableItemDrops);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockSpread(BlockSpreadEvent event) {
        if (this.api.blockItemDropsDisabled(event.getSource())) {
            this.api.disableItemDrops(event.getBlock());
        }
    }
}

