/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.util;

import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.BlockUtil;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.blockutil.api.event.BlockDisableDropEvent;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;

public class BlockHelper {
    private BlockHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Block> getBlockStructure(Block block) {
        Bed otherBedPart;
        Bed bed;
        BlockFace relative;
        Block otherPart;
        BlockData blockData;
        PistonHead pistonHead;
        Block piston;
        Piston piston2;
        Block pistonHead2;
        BlockData blockData2 = block.getBlockData();
        if (blockData2 instanceof Piston && (pistonHead2 = block.getRelative((piston2 = (Piston)blockData2).getFacing())).getType() == Material.PISTON_HEAD) {
            return List.of(block, pistonHead2);
        }
        if (blockData2 instanceof PistonHead && ((piston = block.getRelative((pistonHead = (PistonHead)blockData2).getFacing().getOppositeFace())).getType() == Material.PISTON || piston.getType() == Material.STICKY_PISTON)) {
            return List.of(block, piston);
        }
        if (blockData2 instanceof Bed && (blockData = (otherPart = block.getRelative(relative = (bed = (Bed)blockData2).getPart() == Bed.Part.HEAD ? bed.getFacing() : bed.getFacing().getOppositeFace())).getBlockData()) instanceof Bed && (otherBedPart = (Bed)blockData).getPart() != bed.getPart() && otherBedPart.getFacing() == bed.getFacing()) {
            return List.of(block, otherPart);
        }
        if (blockData2 instanceof Door) {
            Block otherPart2;
            Door door = (Door)blockData2;
            Block block2 = otherPart2 = door.getHalf() == Bisected.Half.BOTTOM ? block.getRelative(BlockFace.UP) : block.getRelative(BlockFace.DOWN);
            if (otherPart2.getType() == blockData2.getMaterial()) {
                return List.of(block, otherPart2);
            }
        }
        return List.of(block);
    }

    public static void breakBlock(Block block, BlockUtil api) {
        BlockDisableDropEvent blockDisableDropEvent = api.newDisable(block.getState());
        if (!blockDisableDropEvent.disableDrops()) {
            return;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Waterlogged) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            block.setType(waterlogged.isWaterlogged() ? Material.WATER : Material.AIR);
        } else {
            block.setType(Material.AIR);
        }
        Location location = block.getLocation().toCenterLocation();
        blockDisableDropEvent.getDropOverride().forEach(itemStack -> block.getWorld().dropItemNaturally(location, itemStack));
        api.enableItemDrops(block);
    }

    public static void breakBlockIfTracked(Block block, BlockUtil api) {
        if (!api.blockItemDropsDisabled(block)) {
            return;
        }
        BlockHelper.breakBlock(block, api);
    }

    public static List<Block> getAdjacentBlocks(Block block) {
        return List.of(block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.WEST));
    }
}

