/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.Schematic;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.SchematicReadException;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.blockpalette.BlockPaletteParser;
import dev.jsinco.brewery.garden.lib.dev.thorinwasher.schem.blockpalette.CommandBlockPaletteParser;
import dev.jsinco.brewery.garden.lib.net.kyori.adventure.nbt.BinaryTag;
import dev.jsinco.brewery.garden.lib.net.kyori.adventure.nbt.BinaryTagIO;
import dev.jsinco.brewery.garden.lib.net.kyori.adventure.nbt.CompoundBinaryTag;
import dev.jsinco.brewery.garden.lib.net.kyori.adventure.nbt.IntBinaryTag;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public final class SchematicReader {
    private static final BinaryTagIO.Reader NBT_READER = BinaryTagIO.unlimitedReader();
    private BlockPaletteParser paletteParser = new CommandBlockPaletteParser();

    public SchematicReader withBlockPaletteParser(BlockPaletteParser parser) {
        this.paletteParser = parser;
        return this;
    }

    @NotNull
    public Schematic read(@NotNull InputStream stream) {
        try {
            return this.read(NBT_READER.readNamed(stream, BinaryTagIO.Compression.GZIP));
        }
        catch (Exception e) {
            throw new SchematicReadException("failed to read schematic NBT", e);
        }
    }

    @NotNull
    public Schematic read(@NotNull Path path) {
        try {
            return this.read(NBT_READER.readNamed(path, BinaryTagIO.Compression.GZIP));
        }
        catch (Exception e) {
            throw new SchematicReadException("failed to read schematic NBT", e);
        }
    }

    @NotNull
    public Schematic read(@NotNull Map.Entry<String, CompoundBinaryTag> namedTag) {
        try {
            BinaryTag schematicTag = namedTag.getValue().get("Schematic");
            if (schematicTag instanceof CompoundBinaryTag) {
                CompoundBinaryTag schematicCompound = (CompoundBinaryTag)schematicTag;
                return this.read(schematicCompound, schematicCompound.getInt("Version"));
            }
            return this.read(namedTag.getValue(), 1);
        }
        catch (Exception e) {
            throw new SchematicReadException("Invalid schematic file", e);
        }
    }

    @NotNull
    private Schematic read(@NotNull CompoundBinaryTag tag, int version) {
        Integer paletteSize;
        byte[] blockArray;
        CompoundBinaryTag palette;
        short width = tag.getShort("Width");
        short height = tag.getShort("Height");
        short length = tag.getShort("Length");
        CompoundBinaryTag metadata = tag.getCompound("Metadata");
        Vector3i offset = new Vector3i();
        if (metadata.keySet().contains("WEOffsetX")) {
            int offsetX = metadata.getInt("WEOffsetX");
            int offsetY = metadata.getInt("WEOffsetY");
            int offsetZ = metadata.getInt("WEOffsetZ");
            offset.set(offsetX, offsetY, offsetZ);
        }
        if (version == 3) {
            CompoundBinaryTag blockEntries = tag.getCompound("Blocks");
            Preconditions.checkNotNull((Object)blockEntries, (Object)"Missing required field 'Blocks'");
            palette = blockEntries.getCompound("Palette");
            Preconditions.checkNotNull((Object)palette, (Object)"Missing required field 'Blocks.Palette'");
            blockArray = blockEntries.getByteArray("Data");
            Preconditions.checkNotNull((Object)blockArray, (Object)"Missing required field 'Blocks.Data'");
            paletteSize = palette.size();
        } else {
            palette = tag.getCompound("Palette");
            Preconditions.checkNotNull((Object)palette, (Object)"Missing required field 'Palette'");
            blockArray = tag.getByteArray("BlockData");
            Preconditions.checkNotNull((Object)blockArray, (Object)"Missing required field 'BlockData'");
            paletteSize = tag.getInt("PaletteMax");
            Preconditions.checkNotNull((Object)paletteSize, (Object)"Missing required field 'PaletteMax'");
        }
        BlockData[] paletteBlocks = new BlockData[paletteSize.intValue()];
        palette.forEach(entry -> {
            try {
                BlockData block;
                int assigned = ((IntBinaryTag)entry.getValue()).value();
                paletteBlocks[assigned] = block = this.paletteParser.parse((String)entry.getKey());
            }
            catch (Exception e) {
                throw new SchematicReadException("Failed to parse block state: " + (String)entry.getKey(), e);
            }
        });
        return new Schematic(new Vector3i((int)width, (int)height, (int)length), offset, paletteBlocks, blockArray);
    }
}

