/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.listener;

import dev.jsinco.brewery.garden.Garden;
import dev.jsinco.brewery.garden.PlantRegistry;
import dev.jsinco.brewery.garden.configuration.BreweryGardenConfig;
import dev.jsinco.brewery.garden.persist.GardenPlantDataType;
import dev.jsinco.brewery.garden.plant.Fruit;
import dev.jsinco.brewery.garden.plant.GardenPlant;
import dev.jsinco.brewery.garden.plant.PlantType;
import dev.jsinco.brewery.garden.plant.Seeds;
import dev.jsinco.brewery.garden.utility.WorldUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EventListeners
implements Listener {
    private BreweryGardenConfig config = Garden.getInstance().getPluginConfiguration();
    private final PlantRegistry gardenRegistry;
    private final GardenPlantDataType gardenPlantDataType;

    public EventListeners(PlantRegistry gardenRegistry, GardenPlantDataType gardenPlantDataType) {
        this.gardenRegistry = gardenRegistry;
        this.gardenPlantDataType = gardenPlantDataType;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null || WorldUtil.isBlacklistedWorld(block.getLocation())) {
            return;
        }
        this.handlePlantShearing(event.getItem(), block);
        if (event.getBlockFace() == BlockFace.UP && event.getAction().isRightClick() && this.config.getPlantableBlocks().contains(block.getType())) {
            event.setCancelled(this.handleSeedPlacement(event.getItem(), block));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPlace(BlockPlaceEvent event) {
        if (Seeds.isSeeds(event.getItemInHand())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        this.gardenPlantDataType.fetch(event.getWorld()).thenAcceptAsync(gardenPlants -> Bukkit.getScheduler().runTask((Plugin)Garden.getInstance(), () -> gardenPlants.forEach(this.gardenRegistry::registerPlant)));
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.gardenRegistry.unregisterWorld(event.getWorld());
    }

    private void handlePlantShearing(ItemStack itemInHand, Block clickedBlock) {
        if (itemInHand == null || itemInHand.getType() != Material.SHEARS) {
            return;
        }
        PlantType plantType = Fruit.getPlantType(clickedBlock);
        if (plantType == null) {
            return;
        }
        clickedBlock.setType(Material.AIR);
        clickedBlock.getWorld().dropItem(clickedBlock.getLocation().toCenterLocation(), plantType.newFruit().newItem(1));
    }

    private boolean handleSeedPlacement(ItemStack itemInHand, Block clickedBlock) {
        if (itemInHand == null || !Seeds.isSeeds(itemInHand)) {
            return false;
        }
        Location location = clickedBlock.getLocation().add(0.0, 1.0, 0.0);
        Seeds seeds = Seeds.getSeeds(itemInHand);
        if (seeds == null) {
            return false;
        }
        GardenPlant gardenPlant = new GardenPlant(seeds.plantType(), location);
        this.gardenRegistry.registerPlant(gardenPlant);
        this.gardenPlantDataType.insert(gardenPlant);
        gardenPlant.getStructure().paste();
        itemInHand.setAmount(itemInHand.getAmount() - 1);
        location.getWorld().playSound(location, Sound.BLOCK_GRASS_PLACE, 1.0f, 1.0f);
        return true;
    }
}

