/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.persist;

import dev.jsinco.brewery.garden.lib.com.zaxxer.hikari.HikariConfig;
import dev.jsinco.brewery.garden.lib.com.zaxxer.hikari.HikariDataSource;
import dev.jsinco.brewery.garden.utility.FileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;

public class Database {
    private static final int DATABASE_VERSION = 0;
    private HikariDataSource hikariDataSource;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public void init(File dataFolder) throws IOException, SQLException {
        HikariConfig config = Database.getHikariConfigForSqlite(dataFolder);
        config.setConnectionInitSql("PRAGMA foreign_keys = ON;");
        this.hikariDataSource = new HikariDataSource(config);
        this.executeMultiple("/sql/create_all_tables.sql");
        try (Connection connection = this.getConnection();){
            ResultSet statement = connection.prepareStatement(FileUtil.readInternalResource("/sql/get_version.sql")).executeQuery();
            if (statement.next()) {
                int version = statement.getInt("version");
                if (version < 0) {
                    this.updateVersion(connection);
                } else if (version > 0) {
                    throw new IllegalStateException("Can not downgrade the plugin!");
                }
            } else {
                this.updateVersion(connection);
            }
        }
    }

    private void updateVersion(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(FileUtil.readInternalResource("/sql/set_version.sql"));){
            preparedStatement.setInt(1, 0);
            preparedStatement.execute();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    @NotNull
    private static HikariConfig getHikariConfigForSqlite(File dataFolder) throws IOException {
        File databaseFile = new File(dataFolder, "garden.db");
        if (!(databaseFile.exists() || databaseFile.getParentFile().mkdirs() || databaseFile.createNewFile())) {
            throw new IOException("Could not create file or dirs");
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName("SQLiteConnectionPool");
        hikariConfig.setDriverClassName("org.sqlite.JDBC");
        hikariConfig.setJdbcUrl("jdbc:sqlite:" + String.valueOf(databaseFile));
        return hikariConfig;
    }

    private void executeMultiple(String resourceString) throws SQLException {
        try (Connection connection = this.hikariDataSource.getConnection();){
            for (String statement : FileUtil.readInternalResource(resourceString).split(";")) {
                connection.prepareStatement(statement + ";").execute();
            }
        }
    }
}

