/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import com.google.common.collect.Sets;
import fuzs.enchantinginfuser.client.gui.components.InfuserMenuButton;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.enchantinginfuser.util.ModEnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jspecify.annotations.Nullable;

public class InfuserEnchantButton
extends InfuserMenuButton {
    public InfuserEnchantButton(int x, int y, class_4185.class_4241 onPress) {
        super(x, y, 160, 185, onPress);
    }

    @Override
    class_124 getStringColor(int value, boolean mayApply) {
        return value < 0 ? class_124.field_1054 : (mayApply ? class_124.field_1060 : class_124.field_1061);
    }

    @Override
    String getStringValue(int value) {
        return value < 0 ? "+" : String.valueOf(value);
    }

    @Override
    class_2561 getNameComponent(class_1799 itemStack, class_9304 itemEnchantments) {
        boolean isEnchanted = !itemEnchantments.method_57543();
        itemStack = ModEnchantmentHelper.getEnchantedItemStack(itemStack, isEnchanted);
        return super.getNameComponent(itemStack, itemEnchantments);
    }

    @Override
    class_1814 getItemNameRarity(class_1799 itemStack, class_9304 itemEnchantments) {
        class_1799 enchantedItemStack = ModEnchantmentHelper.getEnchantedItemStack(itemStack, !itemEnchantments.method_57543());
        return ModEnchantmentHelper.getItemNameRarity(enchantedItemStack, itemEnchantments);
    }

    @Override
    List<class_5348> getCustomLines(class_1799 itemStack, class_9304 itemEnchantments) {
        class_9304 originalEnchantments = class_1890.method_57532((class_1799)itemStack);
        ArrayList<class_5348> newLines = new ArrayList<class_5348>();
        ArrayList<class_5348> changedLines = new ArrayList<class_5348>();
        ArrayList<class_5348> unchangedLines = new ArrayList<class_5348>();
        ArrayList<class_5348> removedLines = new ArrayList<class_5348>();
        this.getEnchantmentLines(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines);
        ArrayList<class_5348> lines = new ArrayList<class_5348>();
        lines.addAll(newLines);
        lines.addAll(changedLines);
        lines.addAll(unchangedLines);
        lines.addAll(removedLines);
        return lines;
    }

    private void getEnchantmentLines(class_9304 itemEnchantments, class_9304 originalEnchantments, List<class_5348> newLines, List<class_5348> changedLines, List<class_5348> unchangedLines, List<class_5348> removedLines) {
        class_5455.class_6890 registries = class_310.method_1551().method_1562().method_29091();
        class_6885 holderSet = InfuserEnchantButton.getTagOrEmpty((class_7225.class_7874)registries, class_7924.field_41265, class_9636.field_51362);
        for (class_6880 enchantment : holderSet) {
            this.addEnchantmentLine(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines, (class_6880<class_1887>)enchantment);
        }
        for (class_6880 enchantment : Sets.union((Set)itemEnchantments.method_57534(), (Set)originalEnchantments.method_57534())) {
            if (holderSet.method_40241(enchantment)) continue;
            this.addEnchantmentLine(itemEnchantments, originalEnchantments, newLines, changedLines, unchangedLines, removedLines, (class_6880<class_1887>)enchantment);
        }
    }

    private void addEnchantmentLine(class_9304 itemEnchantments, class_9304 originalEnchantments, List<class_5348> newLines, List<class_5348> changedLines, List<class_5348> unchangedLines, List<class_5348> removedLines, class_6880<class_1887> enchantment) {
        int oldLevel = originalEnchantments.method_57536(enchantment);
        int newLevel = itemEnchantments.method_57536(enchantment);
        if (newLevel > 0 && oldLevel == 0) {
            class_5250 component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, newLevel);
            newLines.add((class_5348)component.method_27692(class_124.field_1060));
        } else if (newLevel == 0 && oldLevel > 0) {
            class_5250 component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, oldLevel);
            removedLines.add((class_5348)component.method_27692(class_124.field_1061));
        } else if (newLevel > 0 && newLevel != oldLevel) {
            class_5250 component = EnchantmentTooltipHelper.getDisplayName(enchantment);
            class_5250 changeComponent = class_2561.method_43469((String)InfuserMenuButton.KEY_TOOLTIP_CHANGE, (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + oldLevel)), class_2561.method_43471((String)("enchantment.level." + newLevel))});
            changedLines.add((class_5348)component.method_10852(class_5244.field_41874).method_10852((class_2561)changeComponent).method_27692(class_124.field_1054));
        } else if (newLevel > 0) {
            class_5250 component = EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, newLevel);
            unchangedLines.add((class_5348)component.method_27692(class_124.field_1080));
        }
    }

    static <T> class_6885<T> getTagOrEmpty(class_7225.class_7874 registries, class_5321<class_2378<T>> registryKey, class_6862<T> key) {
        Optional optional = registries.method_46762(registryKey).method_46733(key);
        return optional.map(holders -> holders).orElseGet(() -> class_6885.method_40246((class_6880[])new class_6880[0]));
    }

    @Override
    @Nullable class_2561 getLevelsComponent(int value, boolean mayApply) {
        if (mayApply && value < 0) {
            return class_2561.method_43471((String)InfuserMenuButton.KEY_TOOLTIP_EXPERIENCE).method_27692(class_124.field_1080);
        }
        return super.getLevelsComponent(value, mayApply);
    }
}

