/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.google.common.collect.ImmutableSet;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_487;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public record EnchantmentComponent(InfuserMenu.EnchantmentValues enchantmentValues, int enchantmentLevel, Collection<class_6880<class_1887>> incompatibleEnchantments) {
    public static EnchantmentComponent create(class_6880<class_1887> enchantment, InfuserMenu.EnchantmentValues enchantmentValues, class_9304 itemEnchantments) {
        int enchantmentLevel = itemEnchantments.method_57536(enchantment);
        HashSet<class_6880> incompatibleEnchantments = new HashSet<class_6880>();
        for (class_6880 holder : itemEnchantments.method_57534()) {
            if (enchantment.method_55838(holder) || class_1887.method_60033(enchantment, (class_6880)holder)) continue;
            incompatibleEnchantments.add(holder);
        }
        return new EnchantmentComponent(enchantmentValues, enchantmentLevel, (Collection<class_6880<class_1887>>)ImmutableSet.copyOf(incompatibleEnchantments));
    }

    public boolean isPresent() {
        return this.enchantmentLevel > 0;
    }

    public boolean isIncompatible() {
        return !this.incompatibleEnchantments.isEmpty();
    }

    public boolean isInactive() {
        return this.isIncompatible() || this.isNotAvailable();
    }

    public boolean isNotAvailable() {
        return this.enchantmentValues.availableLevel() == 0;
    }

    public class_2561 getDisplayName(class_6880<class_1887> enchantment, int maxWidth, class_327 font, int enchantmentSeed) {
        if (this.isNotAvailable()) {
            int enchantmentId = class_310.method_1551().method_1562().method_29091().method_30530(class_7924.field_41265).method_56158((Object)((class_1887)enchantment.comp_349()));
            class_487.method_2481().method_2480((long)(enchantmentSeed + enchantmentId));
            maxWidth = (int)((float)maxWidth * 0.72f);
            class_5348 randomName = class_487.method_2481().method_2479(font, maxWidth);
            List lines = font.method_1728(randomName, maxWidth);
            if (!lines.isEmpty()) {
                return ComponentHelper.getAsComponent((class_5481)((class_5481)lines.getFirst()));
            }
            return class_2561.method_43470((String)"???????");
        }
        if (this.isPresent()) {
            return EnchantmentTooltipHelper.getDisplayNameWithLevel(enchantment, this.enchantmentLevel);
        }
        return EnchantmentTooltipHelper.getDisplayName(enchantment);
    }

    public List<class_2561> getTooltip(class_6880<class_1887> enchantment) {
        if (this.isNotAvailable()) {
            return this.getWeakPowerTooltip(EnchantmentTooltipHelper.UNKNOWN_ENCHANT_COMPONENT);
        }
        if (this.isIncompatible()) {
            return EnchantmentTooltipHelper.getIncompatibleEnchantmentsTooltip(this.incompatibleEnchantments);
        }
        return EnchantmentTooltipHelper.getEnchantmentTooltip(enchantment);
    }

    public List<class_2561> getWeakPowerTooltip(class_2561 component) {
        return EnchantmentTooltipHelper.getWeakPowerTooltip(this.enchantmentValues.enchantmentPower(), this.enchantmentValues.requiredEnchantmentPower(), component);
    }
}

