/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import fuzs.enchantinginfuser.config.ModifiableItems;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.enchantinginfuser.network.ClientboundInfuserEnchantmentsMessage;
import fuzs.enchantinginfuser.network.client.ServerboundEnchantmentLevelMessage;
import fuzs.enchantinginfuser.util.EnchantmentCostHelper;
import fuzs.enchantinginfuser.util.EnchantmentPowerHelper;
import fuzs.enchantinginfuser.util.ModEnchantmentHelper;
import fuzs.enchantinginfuser.util.PlayerExperienceHelper;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.QuickMoveRuleSet;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1712;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9692;
import net.minecraft.class_9889;

public class InfuserMenu
extends class_1703
implements class_1712 {
    public static final int ENCHANT_BUTTON = 0;
    public static final int REPAIR_BUTTON = 1;
    public static final int ENCHANT_ITEM_SLOT = 0;
    public static final int ENCHANTMENT_POWER_DATA_SLOT = 0;
    public static final int ENCHANTING_COST_DATA_SLOT = 1;
    public static final int REPAIR_COST_DATA_SLOT = 2;
    private final InfuserType infuserType;
    private final class_1263 enchantSlots;
    private final class_3914 levelAccess;
    private final class_1657 player;
    private final class_3915 enchantmentPower = class_3915.method_17403();
    private final class_3915 enchantingCost = class_3915.method_17403();
    private final class_3915 repairCost = class_3915.method_17403();
    private Object2IntMap<class_6880<class_1887>> enchantmentLevels = Object2IntMaps.emptyMap();
    private Object2IntMap<class_6880<class_1887>> availableEnchantmentLevels = Object2IntMaps.emptyMap();
    private Object2IntMap<class_6880<class_1887>> requiredEnchantmentPowers = Object2IntMaps.emptyMap();
    private int originalEnchantingCost;
    private boolean markedDirty;

    public InfuserMenu(int containerId, class_1661 inventory, InfuserType infuserType) {
        this(infuserType, containerId, inventory, (class_1263)new class_1277(1), class_3914.field_17304);
    }

    public InfuserMenu(InfuserType infuserType, int containerId, class_1661 inventory, class_1263 container, class_3914 levelAccess) {
        super((class_3917)ModRegistry.INFUSING_MENU_TYPE.comp_349(), containerId);
        InfuserMenu.method_17359((class_1263)container, (int)1);
        this.infuserType = infuserType;
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.field_7546;
        this.method_7621(new class_1735(this, container, 0, 8, this.getConfig().allowRepairing.isActive() ? 23 : 34){

            public int method_7675() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            class_1304 equipmentSlot = class_1723.field_7832[k];
            class_2960 resourceLocation = (class_2960)class_1723.field_7829.get(equipmentSlot);
            this.method_7621((class_1735)new class_9692((class_1263)inventory, (class_1309)inventory.field_7546, equipmentSlot, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18, resourceLocation));
        }
        ContainerMenuHelper.addInventorySlots((class_1703)this, (class_1661)inventory, (int)30, (int)103);
        this.method_7621(new class_1735(this, (class_1263)inventory, 40, 8, 161){

            public class_2960 method_7679() {
                return class_1723.field_21673;
            }
        });
        this.method_17362(this.enchantmentPower);
        this.method_17362(this.enchantingCost);
        this.method_17362(this.repairCost);
    }

    public ServerConfig.InfuserConfig getConfig() {
        return this.infuserType.getConfig();
    }

    public boolean method_7597(class_1657 player) {
        return this.enchantSlots.method_5443(player);
    }

    public void method_7619(int slotId, int stateId, class_1799 stack) {
        super.method_7619(slotId, stateId, stack);
        this.method_7623();
    }

    public void method_7606(int id, int data) {
        super.method_7606(id, data);
        this.method_7623();
    }

    public void method_7609(class_1263 container) {
        if (container == this.enchantSlots) {
            this.levelAccess.method_17393((level, pos) -> {
                this.enchantmentPower.method_17404(this.getAvailablePower((class_1937)level, (class_2338)pos));
                if (this.mayEnchantStack(this.getEnchantableStack())) {
                    this.setInitialEnchantments((class_1937)level, Optional.of(this.getOriginalEnchantments()));
                    this.enchantingCost.method_17404(this.calculateEnchantingCost());
                    this.repairCost.method_17404(this.calculateRepairCost());
                } else {
                    this.setInitialEnchantments((class_1937)level, Optional.empty());
                    this.enchantingCost.method_17404(0);
                    this.repairCost.method_17404(0);
                }
            });
        }
        super.method_7609(container);
    }

    private boolean mayEnchantStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        if (this.getConfig().allowBooks) {
            if (itemStack.method_31574(class_1802.field_8529)) {
                return true;
            }
            if (itemStack.method_31574(class_1802.field_8598)) {
                return this.getConfig().allowModifyingEnchantments != ModifiableItems.UNENCHANTED;
            }
        } else if (ModEnchantmentHelper.isBook(itemStack)) {
            return false;
        }
        return this.getConfig().allowModifyingEnchantments.predicate.test(itemStack);
    }

    private int getAvailablePower(class_1937 level, class_2338 pos) {
        float enchantingPower = 0.0f;
        float maxPowerScale = 1.0f;
        for (class_2338 offset : class_2331.field_36535) {
            if (!InfuserBlock.isValidBookShelf(level, pos, offset)) continue;
            class_2680 blockState = level.method_8320(pos.method_10081((class_2382)offset));
            enchantingPower += EnchantingBehavior.get().getEnchantmentPower(blockState, level, pos.method_10081((class_2382)offset));
            maxPowerScale = Math.max(maxPowerScale, EnchantingBehavior.get().getEnchantmentPowerLimitScale(blockState, level, pos.method_10081((class_2382)offset)));
        }
        return (int)Math.min(Math.max(0.0f, enchantingPower), (float)this.getConfig().maximumBookshelves * maxPowerScale);
    }

    public void method_7635(class_1703 containerMenu, int dataSlotIndex, class_1799 itemStack) {
        if (containerMenu == this && dataSlotIndex == 0) {
            this.method_7609(this.enchantSlots);
        }
    }

    public void method_7633(class_1703 containerMenu, int dataSlotIndex, int value) {
    }

    public boolean clickClientEnchantmentLevelButton(class_6880<class_1887> enchantment, int enchantmentLevel, ServerboundEnchantmentLevelMessage.Operation operation) {
        int newLevel = this.clickEnchantmentLevelButton(enchantment, operation);
        if (newLevel != enchantmentLevel) {
            MessageSender.broadcast((Message)new ServerboundEnchantmentLevelMessage(this.field_7763, enchantment, operation));
            return true;
        }
        return false;
    }

    public int clickEnchantmentLevelButton(class_6880<class_1887> enchantment, IntUnaryOperator operation) {
        int enchantmentLevel = this.enchantmentLevels.getInt(enchantment);
        if (enchantmentLevel == 0 && !class_1890.method_8201((Collection)this.getItemEnchantments().method_57534(), enchantment)) {
            return 0;
        }
        int newEnchantmentLevel = operation.applyAsInt(enchantmentLevel);
        newEnchantmentLevel = class_3532.method_15340((int)newEnchantmentLevel, (int)0, (int)EnchantingBehavior.get().getMaxLevel(enchantment));
        if ((newEnchantmentLevel = Math.min(newEnchantmentLevel, this.getAvailableEnchantmentLevel(enchantment))) != enchantmentLevel) {
            this.enchantmentLevels.put(enchantment, newEnchantmentLevel);
            this.markedDirty = !this.getItemEnchantments().equals((Object)this.getOriginalEnchantments());
            this.enchantingCost.method_17404(this.calculateEnchantingCost());
            this.method_7623();
        }
        return newEnchantmentLevel;
    }

    public boolean method_7604(class_1657 player, int id) {
        return switch (id) {
            case 0 -> this.clickEnchantButton(player);
            case 1 -> this.clickRepairButton(player);
            default -> false;
        };
    }

    private boolean clickEnchantButton(class_1657 player) {
        if (this.canEnchant(player)) {
            this.levelAccess.method_17393((level, pos) -> {
                this.processEnchantingCost(player, (class_1937)level, (class_2338)pos, this.getEnchantingCost());
                class_1799 itemStack = ModEnchantmentHelper.setNewEnchantments(this.getEnchantableStack(), this.enchantmentLevels, this.getConfig().increaseAnvilRepairCost);
                this.enchantSlots.method_5447(0, itemStack);
                if (this.getEnchantingCost() > 0) {
                    player.method_7281(class_3468.field_15420);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        class_174.field_1181.method_8870(serverPlayer, itemStack, this.getEnchantingCost());
                    }
                }
                this.enchantSlots.method_5431();
                this.method_7609(this.enchantSlots);
                level.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.1f + 0.9f);
            });
            return true;
        }
        return false;
    }

    private void processEnchantingCost(class_1657 player, class_1937 level, class_2338 pos, int enchantingCost) {
        if (enchantingCost < 0) {
            class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos), (int)PlayerExperienceHelper.calculateExperienceDelta(this.getItemEnchantments(), this.getOriginalEnchantments(), level.field_9229));
        } else if (!player.method_31549().field_7477) {
            player.method_7316(-enchantingCost);
        }
    }

    private int calculateEnchantingCost() {
        int enchantmentCosts = this.getScaledEnchantmentCosts(this.getItemEnchantments()) - this.originalEnchantingCost;
        if (enchantmentCosts == 0 && this.markedDirty) {
            return 1;
        }
        return enchantmentCosts;
    }

    private boolean clickRepairButton(class_1657 player) {
        if (this.canRepair(player)) {
            this.levelAccess.method_17393((level, pos) -> {
                if (!player.method_31549().field_7477) {
                    player.method_7316(-this.getRepairCost());
                }
                class_1799 itemStack = this.getEnchantableStack();
                int itemRepairCost = (Integer)itemStack.method_58695(class_9334.field_49639, (Object)0);
                itemStack = itemStack.method_7972();
                itemStack.method_7974(0);
                if (this.getConfig().increaseAnvilRepairCost) {
                    itemStack.method_57379(class_9334.field_49639, (Object)class_1706.method_20398((int)itemRepairCost));
                }
                this.enchantSlots.method_5447(0, itemStack);
                level.method_20290(1030, pos, 0);
            });
            return true;
        }
        return false;
    }

    private int calculateRepairCost() {
        class_1799 itemStack = this.getEnchantableStack();
        if (this.getConfig().allowRepairing.canRepair(itemStack)) {
            double repairStep = (double)itemStack.method_7936() * this.getConfig().repair.repairPercentageStep;
            return (int)Math.ceil(Math.ceil((double)itemStack.method_7919() / repairStep) * this.getConfig().repair.repairStepMultiplier);
        }
        return 0;
    }

    private int getScaledEnchantmentCosts(class_9304 itemEnchantments) {
        float enchantmentCostsScale;
        if (ModEnchantmentHelper.isBook(this.getEnchantableStack())) {
            enchantmentCostsScale = 1.0f;
        } else {
            int scalingEnchantmentCosts = EnchantmentCostHelper.getScalingEnchantmentCosts((Collection<class_6880<class_1887>>)this.availableEnchantmentLevels.keySet(), this.getScalingNamespaces());
            int maximumCost = class_3532.method_15386((float)((float)this.getConfig().costs.maximumCost * EnchantingBehavior.get().getMaximumCostMultiplier()));
            enchantmentCostsScale = Math.min(1.0f, (float)maximumCost / (float)scalingEnchantmentCosts);
        }
        float enchantmentCosts = EnchantmentCostHelper.getEnchantmentCosts(itemEnchantments, enchantmentCostsScale);
        int minimumCosts = itemEnchantments.method_57539().stream().mapToInt(Object2IntMap.Entry::getIntValue).sum();
        return Math.max(class_3532.method_15386((float)enchantmentCosts), minimumCosts);
    }

    private Collection<String> getScalingNamespaces() {
        if (this.getConfig().costs.scaleCostsByVanillaOnly) {
            return EnchantingBehavior.get().getScalingNamespaces();
        }
        return Collections.emptySet();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return QuickMoveRuleSet.of((class_1703)this, (x$0, x$1, x$2, x$3) -> this.method_7616(x$0, x$1, x$2, x$3)).addContainerSlotRule(0).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }

    public int getEnchantmentPower() {
        return Math.min(this.enchantmentPower.method_17407(), this.getEnchantmentPowerLimit());
    }

    public int getEnchantmentPowerLimit() {
        return EnchantingBehavior.get().getEnchantmentPowerLimit(this.infuserType);
    }

    public class_1799 getEnchantableStack() {
        return this.enchantSlots.method_5438(0);
    }

    public int getEnchantingCost() {
        return this.enchantingCost.method_17407();
    }

    public int getRepairCost() {
        return this.repairCost.method_17407();
    }

    public boolean canEnchant(class_1657 player) {
        if (!this.getEnchantableStack().method_7960() && this.markedDirty) {
            return player.field_7520 >= this.getEnchantingCost() || player.method_31549().field_7477;
        }
        return false;
    }

    public boolean canRepair(class_1657 player) {
        if (this.getConfig().allowRepairing.canRepair(this.getEnchantableStack())) {
            return player.field_7520 >= this.getRepairCost() || player.method_31549().field_7477;
        }
        return false;
    }

    public class_9304 getItemEnchantments() {
        class_9304.class_9305 itemEnchantments = new class_9304.class_9305(class_9304.field_49385);
        for (Object2IntMap.Entry entry : this.enchantmentLevels.object2IntEntrySet()) {
            itemEnchantments.method_57547((class_6880)entry.getKey(), entry.getIntValue());
        }
        return itemEnchantments.method_57549();
    }

    public Set<class_6880<class_1887>> getAllEnchantments() {
        return this.availableEnchantmentLevels.keySet();
    }

    public int getAvailableEnchantmentLevel(class_6880<class_1887> enchantment) {
        return this.availableEnchantmentLevels.getInt(enchantment);
    }

    private class_9304 getOriginalEnchantments() {
        return class_1890.method_57532((class_1799)this.getEnchantableStack());
    }

    private int getRequiredEnchantmentPower(class_6880<class_1887> enchantment) {
        return this.requiredEnchantmentPowers.getInt(enchantment);
    }

    public void setInitialEnchantments(class_1937 level, Optional<class_9304> itemEnchantments) {
        this.setItemEnchantments(itemEnchantments.orElse(class_9304.field_49385));
        if (itemEnchantments.isPresent()) {
            this.initializeEnchantmentMaps(level);
            this.originalEnchantingCost = this.getScaledEnchantmentCosts(itemEnchantments.get());
        } else {
            this.availableEnchantmentLevels = Object2IntMaps.emptyMap();
            this.requiredEnchantmentPowers = Object2IntMaps.emptyMap();
            this.originalEnchantingCost = 0;
        }
        this.sendEnchantments(itemEnchantments);
    }

    private void setItemEnchantments(class_9304 itemEnchantments) {
        Object2IntOpenHashMap enchantmentLevels = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
            enchantmentLevels.put((Object)((class_6880)entry.getKey()), entry.getIntValue());
        }
        this.enchantmentLevels = enchantmentLevels;
        this.markedDirty = false;
    }

    private void initializeEnchantmentMaps(class_1937 level) {
        Collection<class_6880<class_1887>> enchantments = ModEnchantmentHelper.getEnchantmentsForItem(level.method_30349(), this.getEnchantableStack(), this.infuserType.getAvailableEnchantments(), !this.getConfig().allowAnvilEnchantments);
        int enchantmentValue = this.getEnchantableStack().method_57826(class_9334.field_53695) ? ((class_9889)this.getEnchantableStack().method_58694(class_9334.field_53695)).comp_2938() : 0;
        this.availableEnchantmentLevels = EnchantmentPowerHelper.getAvailableEnchantmentLevels(this.getEnchantmentPower(), enchantments, this.getEnchantmentPowerLimit(), enchantmentValue);
        if (level.method_8608()) {
            this.requiredEnchantmentPowers = EnchantmentPowerHelper.getRequiredEnchantmentPowers(this.getEnchantmentPower(), enchantments, this.getEnchantmentPowerLimit(), enchantmentValue);
        }
    }

    private void sendEnchantments(Optional<class_9304> itemEnchantments) {
        this.levelAccess.method_17393((level, blockPos) -> MessageSender.broadcast((PlayerSet)PlayerSet.ofEntity((class_1297)this.player), (Message)new ClientboundInfuserEnchantmentsMessage(this.field_7763, itemEnchantments)));
    }

    public EnchantmentValues getEnchantmentValues(class_6880<class_1887> enchantment) {
        int maxLevel = EnchantingBehavior.get().getMaxLevel(enchantment);
        int availableLevel = this.getAvailableEnchantmentLevel(enchantment);
        int requiredEnchantmentPower = this.getRequiredEnchantmentPower(enchantment);
        return new EnchantmentValues(maxLevel, availableLevel, this.getEnchantmentPower(), requiredEnchantmentPower);
    }

    public record EnchantmentValues(int maxLevel, int availableLevel, int enchantmentPower, int requiredEnchantmentPower) {
    }
}

