/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;

public abstract class AbstractMenuSelectionList<E extends Entry<E>>
extends ContainerObjectSelectionList<E> {
    private static final Identifier SCROLLER_SPRITE = Identifier.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private static final Identifier SCROLLER_DISABLED_SPRITE = Identifier.withDefaultNamespace((String)"container/creative_inventory/scroller_disabled");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private final int scrollbarOffset;

    public AbstractMenuSelectionList(Minecraft minecraft, int x, int y, int width, int height, int itemHeight, int scrollbarOffset) {
        super(minecraft, width, height, y, itemHeight);
        this.scrollbarOffset = scrollbarOffset;
        this.setX(x);
    }

    public int addEntry(E entry) {
        return super.addEntry(entry);
    }

    public void clearEntries() {
        super.clearEntries();
    }

    public int getRowWidth() {
        return this.getWidth();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        int posX = this.scrollBarX();
        double scrollAmount = this.maxScrollAmount() > 0 ? this.scrollAmount() / (double)this.maxScrollAmount() : 0.0;
        int posY = this.getY() + (int)(scrollAmount * (double)(this.getHeight() - 15));
        Identifier identifier = this.maxScrollAmount() > 0 ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, posX, posY, 12, 15);
    }

    protected boolean scrollbarVisible() {
        return false;
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected int getFirstEntryY() {
        return this.getY();
    }

    protected int contentHeight() {
        return super.contentHeight() - 4;
    }

    public int maxScrollAmount() {
        return Math.max(0, this.contentHeight() - this.getHeight());
    }

    protected int scrollBarX() {
        return this.getRowRight() + this.scrollbarOffset;
    }

    public boolean updateScrolling(MouseButtonEvent mouseButtonEvent) {
        this.scrolling = this.isValidClickButton(mouseButtonEvent.buttonInfo()) && this.isMouseOverScrollbar(mouseButtonEvent.x(), mouseButtonEvent.y());
        return this.scrolling;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        if (!this.isValidClickButton(mouseButtonEvent.buttonInfo())) {
            return false;
        }
        this.updateScrolling(mouseButtonEvent);
        if (this.scrolling) {
            this.setScrollAmountFromMouse(mouseButtonEvent.y());
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, doubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        if (this.scrolling) {
            this.setScrollAmountFromMouse(mouseButtonEvent.y());
            return true;
        }
        return super.mouseDragged(mouseButtonEvent, dragX, dragY);
    }

    protected void setScrollAmountFromMouse(double mouseY) {
        double scrollOffs = (mouseY - (double)this.getY() - 7.5) / (double)(this.getHeight() - 15);
        this.setScrollAmount(Mth.clamp((double)scrollOffs, (double)0.0, (double)1.0) * (double)this.maxScrollAmount());
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) || this.isMouseOverScrollbar(mouseX, mouseY);
    }

    protected boolean isMouseOverScrollbar(double mouseX, double mouseY) {
        return ScreenHelper.isHovering((int)this.scrollBarX(), (int)this.getY(), (int)12, (int)this.getHeight(), (double)mouseX, (double)mouseY);
    }

    protected void renderSelection(GuiGraphics guiGraphics, E entry, int innerColor) {
    }

    public int getRowLeft() {
        return this.getX();
    }

    public int getRowTop(int index) {
        return super.getRowTop(index) - 4;
    }

    protected static abstract class Entry<E extends Entry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        protected Entry() {
        }

        public int getContentX() {
            return this.getX();
        }

        public int getContentY() {
            return this.getY();
        }

        public int getContentHeight() {
            return this.getHeight();
        }

        public int getContentWidth() {
            return this.getWidth();
        }

        protected <T extends AbstractWidget> T addRenderableWidget(T widget) {
            this.children.add(widget);
            return widget;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            for (AbstractWidget abstractWidget : this.children) {
                abstractWidget.setY(this.getContentY());
                abstractWidget.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }
}

