/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.components;

import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.puzzleslib.api.client.gui.v2.GuiGraphicsHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jspecify.annotations.Nullable;

public abstract class InfuserMenuButton
extends SpritelessImageButton {
    public static final String KEY_TOOLTIP_EXPERIENCE = Util.makeDescriptionId((String)"gui", (Identifier)EnchantingInfuser.id("infusing.tooltip.points"));
    public static final String KEY_TOOLTIP_CHANGE = Util.makeDescriptionId((String)"gui", (Identifier)EnchantingInfuser.id("infusing.tooltip.change"));
    public static final String KEY_TOOLTIP_DURABILITY = Util.makeDescriptionId((String)"gui", (Identifier)EnchantingInfuser.id("infusing.tooltip.durability"));
    public static final String KEY_TOOLTIP_HINT = Util.makeDescriptionId((String)"gui", (Identifier)EnchantingInfuser.id("infusing.tooltip.enchanting_power_hint"));
    private int color = -1;

    public InfuserMenuButton(int x, int y, int xTexStart, int yTexStart, Button.OnPress onPress) {
        super(x, y, 18, 18, xTexStart, yTexStart, InfuserScreen.INFUSER_LOCATION, onPress);
        this.setTextureLayout(SpritelessImageButton.LEGACY_TEXTURE_LAYOUT);
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderContents(guiGraphics, mouseX, mouseY, partialTick);
        this.drawStringWithBackground(guiGraphics, this.getX() + 1, this.getY() + 1, this.getMessage(), this.color);
    }

    protected void drawStringWithBackground(GuiGraphics guiGraphics, int posX, int posY, Component component, int color) {
        Font font = Minecraft.getInstance().font;
        GuiGraphicsHelper.drawInBatch8xOutline((GuiGraphics)guiGraphics, (Font)font, (Component)component, (int)(posX + (17 - font.width((FormattedText)component))), (int)(posY + 9), (int)ARGB.opaque((int)color), (int)ARGB.opaque((int)0));
    }

    public void refreshMessage(int value, boolean mayApply) {
        this.setMessage((Component)(value != 0 ? Component.literal((String)this.getStringValue(value)) : CommonComponents.EMPTY));
        this.color = this.getStringColor(value, mayApply).getColor();
    }

    abstract ChatFormatting getStringColor(int var1, boolean var2);

    abstract String getStringValue(int var1);

    public void refreshTooltip(ItemStack itemStack, ItemEnchantments itemEnchantments, int value, boolean mayApply) {
        List<FormattedText> tooltipLines = this.getTooltipLines(itemStack, itemEnchantments, value, mayApply);
        TooltipBuilder.create().addLines(tooltipLines).build((AbstractWidget)this);
    }

    private List<FormattedText> getTooltipLines(ItemStack itemStack, ItemEnchantments itemEnchantments, int value, boolean mayApply) {
        Component levelsComponent;
        if (!mayApply && value == 0) {
            return Collections.emptyList();
        }
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        if (mayApply) {
            lines.add((FormattedText)this.getNameComponent(itemStack, itemEnchantments));
            lines.addAll(this.getCustomLines(itemStack, itemEnchantments));
        }
        if ((levelsComponent = this.getLevelsComponent(value, mayApply)) != null) {
            if (!lines.isEmpty()) {
                lines.add((FormattedText)CommonComponents.EMPTY);
            }
            lines.add((FormattedText)levelsComponent);
        }
        return lines;
    }

    Component getNameComponent(ItemStack itemStack, ItemEnchantments itemEnchantments) {
        MutableComponent component = Component.empty().append(itemStack.getHoverName()).withStyle(this.getItemNameRarity(itemStack, itemEnchantments).color());
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            component.withStyle(ChatFormatting.ITALIC);
        }
        return component;
    }

    Rarity getItemNameRarity(ItemStack itemStack, ItemEnchantments itemEnchantments) {
        return itemStack.getRarity();
    }

    abstract List<FormattedText> getCustomLines(ItemStack var1, ItemEnchantments var2);

    @Nullable Component getLevelsComponent(int value, boolean mayApply) {
        if (mayApply) {
            if (value != 0) {
                if (value == 1) {
                    return Component.translatable((String)"container.enchant.level.one").withStyle(ChatFormatting.GRAY);
                }
                return Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY);
            }
            return null;
        }
        return Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{value}).withStyle(ChatFormatting.RED);
    }
}

