/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.components.AbstractMenuSelectionList;
import fuzs.enchantinginfuser.client.gui.components.EnchantingOperationButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserEnchantButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserMenuButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserRepairButton;
import fuzs.enchantinginfuser.client.gui.screens.inventory.EnchantmentComponent;
import fuzs.enchantinginfuser.client.util.EnchantmentTooltipHelper;
import fuzs.enchantinginfuser.network.client.ServerboundEnchantmentLevelMessage;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu>
implements ContainerListener {
    public static final Identifier INFUSER_LOCATION = EnchantingInfuser.id("textures/gui/container/enchanting_infuser.png");
    private static final Identifier SLOT_HIGHLIGHT_BACK_SPRITE = Identifier.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final Identifier SLOT_HIGHLIGHT_FRONT_SPRITE = Identifier.withDefaultNamespace((String)"container/slot_highlight_front");
    private static final int BUTTONS_OFFSET_X = 7;
    private static final int ENCHANT_BUTTON_OFFSET_Y = 44;
    private static final int ENCHANT_ONLY_BUTTON_OFFSET_Y = 55;
    private static final int REPAIR_BUTTON_OFFSET_Y = 66;
    private static boolean isPowerTooLow;
    public final int enchantmentSeed = new Random().nextInt();
    private EditBox searchBox;
    private EnchantmentSelectionList scrollingList;
    private boolean ignoreTextInput;
    private AbstractWidget powerWidget;
    private InfuserMenuButton enchantButton;
    private @Nullable InfuserMenuButton repairButton;

    public InfuserScreen(InfuserMenu infuserMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)infuserMenu, inventory, title);
        this.imageWidth = 220;
        this.imageHeight = 185;
        this.inventoryLabelX = 30;
        this.inventoryLabelY = this.imageHeight - 94;
        ((InfuserMenu)this.menu).addSlotListener(this);
    }

    public static void setIsPowerTooLow(boolean isPowerTooLow) {
        InfuserScreen.isPowerTooLow = isPowerTooLow;
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 67, this.topPos + 6, 116, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(-1);
        this.addWidget((GuiEventListener)this.searchBox);
        this.scrollingList = new EnchantmentSelectionList(this.leftPos + 30, this.topPos + 18);
        this.addRenderableWidget((GuiEventListener)this.scrollingList);
        this.powerWidget = (AbstractWidget)this.addRenderableOnly((Renderable)new AbstractWidget(this.leftPos + 196, this.topPos + 161, 16, 16, CommonComponents.EMPTY){

            protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.isHoveredOrFocused()) {
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, this.getX() - 4, this.getY() - 4, 24, 24);
                }
                guiGraphics.renderFakeItem(new ItemStack((ItemLike)Items.BOOKSHELF), this.getX(), this.getY());
                int posX = this.getX() + 19 - 2 - InfuserScreen.this.font.width((FormattedText)this.getMessage());
                int posY = this.getY() + 6 + 3;
                guiGraphics.drawString(InfuserScreen.this.font, this.getMessage(), posX, posY, ARGB.opaque((int)this.getStringColor().getColor()));
                if (this.isHoveredOrFocused()) {
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, this.getX() - 4, this.getY() - 4, 24, 24);
                }
            }

            private ChatFormatting getStringColor() {
                if (((InfuserMenu)InfuserScreen.this.menu).getEnchantmentPower() >= ((InfuserMenu)InfuserScreen.this.menu).getEnchantmentPowerLimit()) {
                    return ChatFormatting.YELLOW;
                }
                if (isPowerTooLow) {
                    return ChatFormatting.RED;
                }
                return ChatFormatting.WHITE;
            }

            public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
                return false;
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            }
        });
        this.enchantButton = (InfuserMenuButton)this.addRenderableWidget((GuiEventListener)new InfuserEnchantButton(this.leftPos + 7, this.topPos + (((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? 44 : 55), button -> {
            if (((InfuserMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 0)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((InfuserMenu)this.menu).containerId, 0);
            }
            this.searchBox.setValue("");
        }));
        this.repairButton = ((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? (InfuserMenuButton)this.addRenderableWidget((GuiEventListener)new InfuserRepairButton(this.leftPos + 7, this.topPos + 66, button -> {
            if (((InfuserMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 1)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((InfuserMenu)this.menu).containerId, 1);
            }
        })) : null;
        this.refreshButton(0);
        this.refreshButton(1);
        this.refreshButton(2);
    }

    private void refreshButton(int dataSlot) {
        switch (dataSlot) {
            case 0: {
                this.refreshEnchantingPower(((InfuserMenu)this.menu).getEnchantmentPower());
                break;
            }
            case 1: {
                this.refreshButton(this.enchantButton, ((InfuserMenu)this.menu).getEnchantingCost(), ((InfuserMenu)this.menu).canEnchant((Player)this.minecraft.player));
                break;
            }
            case 2: {
                if (this.repairButton == null) break;
                this.refreshButton(this.repairButton, ((InfuserMenu)this.menu).getRepairCost(), ((InfuserMenu)this.menu).canRepair((Player)this.minecraft.player));
            }
        }
    }

    private void refreshButton(InfuserMenuButton button, int value, boolean mayApply) {
        button.refreshMessage(value, mayApply);
        button.refreshTooltip(((InfuserMenu)this.menu).getEnchantableStack(), ((InfuserMenu)this.menu).getItemEnchantments(), value, mayApply);
        button.active = mayApply;
    }

    private void refreshEnchantingPower(int enchantmentPower) {
        this.powerWidget.setMessage((Component)Component.literal((String)String.valueOf(enchantmentPower)));
        int enchantmentPowerLimit = ((InfuserMenu)this.menu).getEnchantmentPowerLimit();
        TooltipBuilder builder = TooltipBuilder.create().splitLines(200).addLines(new FormattedText[]{Component.translatable((String)EnchantmentTooltipHelper.KEY_CURRENT_ENCHANTING_POWER, (Object[])new Object[]{enchantmentPower, enchantmentPowerLimit}).withStyle(ChatFormatting.YELLOW)});
        if (enchantmentPower < enchantmentPowerLimit) {
            builder.addLines(new FormattedText[]{Component.translatable((String)InfuserMenuButton.KEY_TOOLTIP_HINT).withStyle(ChatFormatting.GRAY)});
        }
        builder.build(this.powerWidget);
    }

    public void removed() {
        super.removed();
        ((InfuserMenu)this.menu).removeSlotListener(this);
    }

    public void resize(int width, int height) {
        String string = this.searchBox.getValue();
        super.resize(width, height);
        this.searchBox.setValue(string);
        this.refreshSearchResults();
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.charTyped(characterEvent)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        this.ignoreTextInput = false;
        if (!this.searchBox.isFocused()) {
            if (this.minecraft.options.keyChat.matches(keyEvent)) {
                this.ignoreTextInput = true;
                this.searchBox.setFocused(true);
                return true;
            }
            return super.keyPressed(keyEvent);
        }
        boolean flag = this.hoveredSlot != null && this.hoveredSlot.hasItem();
        boolean flag1 = InputConstants.getKey((KeyEvent)keyEvent).getNumericKeyValue().isPresent();
        if (flag && flag1 && this.checkHotbarKeyPressed(keyEvent)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.keyPressed(keyEvent)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.isFocused() && this.searchBox.isVisible() && !keyEvent.isEscape() || super.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        this.ignoreTextInput = false;
        return super.keyReleased(keyEvent);
    }

    public void refreshSearchResults() {
        EnchantmentComponent enchantmentComponent;
        InfuserMenu.EnchantmentValues enchantmentValues;
        int size = this.scrollingList.children().size();
        this.scrollingList.clearEntries();
        ItemEnchantments itemEnchantments = ((InfuserMenu)this.menu).getItemEnchantments();
        Set<Holder<Enchantment>> enchantments = ((InfuserMenu)this.menu).getAllEnchantments();
        RegistryAccess.Frozen registries = this.minecraft.getConnection().registryAccess();
        HolderSet.Named holders = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.TOOLTIP_ORDER);
        for (Holder<Enchantment> enchantment : holders) {
            if (!enchantments.contains(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.menu).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        for (Holder<Enchantment> enchantment : enchantments) {
            if (holders.contains(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.menu).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        if (size != this.scrollingList.children().size()) {
            this.scrollingList.setScrollAmount(0.0);
        }
    }

    private boolean matchesSearch(Holder<Enchantment> enchantment) {
        String s = this.searchBox.getValue().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            return true;
        }
        if (((InfuserMenu)this.menu).getAvailableEnchantmentLevel(enchantment) == 0) {
            return false;
        }
        return ((Enchantment)enchantment.value()).description().getString().toLowerCase(Locale.ROOT).contains(s);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        isPowerTooLow = false;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, INFUSER_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, INFUSER_LOCATION, this.leftPos + 8 - 1, this.topPos + (((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? 23 : 34) - 1, 196.0f, 185.0f, 18, 18, 256, 256);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseScrolled(mouseX, mouseY, scrollX, scrollY)).isPresent()) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike() && this.getFocused() != null && this.isDragging() && mouseButtonEvent.button() == 0 && this.getFocused().mouseDragged(mouseButtonEvent, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseButtonEvent, dragX, dragY);
    }

    public void slotChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, ItemStack itemStack) {
        if (dataSlotIndex == 0) {
            this.refreshButton(1);
            this.refreshButton(2);
        }
    }

    public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        this.refreshButton(dataSlotIndex);
    }

    private class EnchantmentSelectionList
    extends AbstractMenuSelectionList<Entry> {
        public EnchantmentSelectionList(int x, int y) {
            super(InfuserScreen.this.minecraft, x, y, 160, 70, 18, 8);
        }

        public void addEntry(Holder<Enchantment> enchantment, EnchantmentComponent enchantmentComponent) {
            this.addEntry(new Entry(enchantment, enchantmentComponent));
        }

        @Override
        public void clearEntries() {
            super.clearEntries();
        }

        class Entry
        extends AbstractMenuSelectionList.Entry<Entry> {
            private final EnchantmentComponent enchantmentComponent;
            private final Component component;
            private final List<FormattedCharSequence> tooltip;

            public Entry(Holder<Enchantment> enchantment, EnchantmentComponent enchantmentComponent) {
                this.enchantmentComponent = enchantmentComponent;
                this.component = ComponentUtils.mergeStyles((Component)enchantmentComponent.getDisplayName(enchantment, EnchantmentSelectionList.this.getWidth() - 36, ((EnchantmentSelectionList)EnchantmentSelectionList.this).minecraft.font, InfuserScreen.this.enchantmentSeed), (Style)Style.EMPTY.withColor(ARGB.opaque((int)this.getFontColor())));
                this.tooltip = ClientComponentSplitter.splitTooltipLines(enchantmentComponent.getTooltip(enchantment)).toList();
                this.addRenderableWidget(new EnchantingOperationButton.Remove(enchantmentComponent, EnchantmentSelectionList.this.getX(), EnchantmentSelectionList.this.getY(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.getMenu()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.remove())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                }));
                this.addRenderableWidget(new EnchantingOperationButton.Add(enchantmentComponent, EnchantmentSelectionList.this.getX() + EnchantmentSelectionList.this.getWidth() - 18, EnchantmentSelectionList.this.getY(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.getMenu()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.add())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                }));
            }

            @Override
            public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, INFUSER_LOCATION, this.getContentX(), this.getContentY(), 0.0f, (float)(185 + this.getYImage() * EnchantmentSelectionList.this.defaultEntryHeight), this.getContentWidth(), this.getContentHeight(), 256, 256);
                guiGraphics.textRenderer(GuiGraphics.HoveredTextEffects.NONE).acceptScrollingWithDefaultCenter(this.component, this.getContentX() + 18 + 2, this.getContentRight() - 18 - 2, this.getContentY(), this.getContentBottom());
                super.renderContent(guiGraphics, mouseX, mouseY, hovering, partialTick);
                if (hovering && (this.enchantmentComponent.isInactive() || mouseX >= this.getContentX() + 18 && mouseX < this.getContentRight() - 18)) {
                    guiGraphics.setTooltipForNextFrame(this.tooltip, mouseX, mouseY);
                    if (this.enchantmentComponent.isNotAvailable()) {
                        InfuserScreen.setIsPowerTooLow(true);
                    }
                }
            }

            private int getYImage() {
                return this.enchantmentComponent.isInactive() ? 0 : (this.enchantmentComponent.isPresent() ? 2 : 1);
            }

            private int getFontColor() {
                return this.enchantmentComponent.isInactive() ? 6839882 : (this.enchantmentComponent.isPresent() ? ChatFormatting.YELLOW.getColor() : -1);
            }
        }
    }
}

