/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.renderer.blockentity.state.InfuserRenderState;
import fuzs.enchantinginfuser.world.level.block.entity.InfuserBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.book.BookModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.blockentity.state.EnchantTableRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class InfuserRenderer
implements BlockEntityRenderer<InfuserBlockEntity, InfuserRenderState> {
    public static final Material BOOK_LOCATION = Sheets.BLOCK_ENTITIES_MAPPER.apply(EnchantingInfuser.id("enchanting_infuser_book"));
    public final ItemModelResolver itemModelResolver;
    private final MaterialSet materials;
    private final BookModel bookModel;
    private final EnchantTableRenderer enchantTableRenderer;

    public InfuserRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
        this.materials = context.materials();
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
        this.enchantTableRenderer = new EnchantTableRenderer(context);
    }

    public InfuserRenderState createRenderState() {
        return new InfuserRenderState();
    }

    public void extractRenderState(InfuserBlockEntity blockEntity, InfuserRenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        this.enchantTableRenderer.extractRenderState((EnchantingTableBlockEntity)blockEntity, (EnchantTableRenderState)renderState, partialTick, cameraPosition, crumblingOverlay);
        renderState.item.clear();
        this.itemModelResolver.updateForTopItem(renderState.item, blockEntity.getItem(0), ItemDisplayContext.GROUND, blockEntity.getLevel(), null, 0);
    }

    public void submit(InfuserRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        this.submitBook(renderState, poseStack, submitNodeCollector);
        this.submitItem(renderState, poseStack, submitNodeCollector);
    }

    private void submitBook(EnchantTableRenderState enchantTableRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.75f, 0.5f);
        poseStack.translate(0.0f, 0.1f + Mth.sin((double)(enchantTableRenderState.time * 0.1f)) * 0.01f, 0.0f);
        float f = enchantTableRenderState.yRot;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation(-f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(80.0f));
        float g = Mth.frac((float)(enchantTableRenderState.flip + 0.25f)) * 1.6f - 0.3f;
        float h = Mth.frac((float)(enchantTableRenderState.flip + 0.75f)) * 1.6f - 0.3f;
        BookModel.State state = new BookModel.State(enchantTableRenderState.time, Mth.clamp((float)g, (float)0.0f, (float)1.0f), Mth.clamp((float)h, (float)0.0f, (float)1.0f), enchantTableRenderState.open);
        submitNodeCollector.submitModel((Model)this.bookModel, (Object)state, poseStack, BOOK_LOCATION.renderType(RenderTypes::entitySolid), enchantTableRenderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materials.get(BOOK_LOCATION), 0, enchantTableRenderState.breakProgress);
        poseStack.popPose();
    }

    private void submitItem(InfuserRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        if (renderState.open > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.0f, 0.5f);
            float hoverOffset = Mth.sin((double)(renderState.time / 10.0f)) * 0.1f + 0.1f;
            AABB aABB = renderState.item.getModelBoundingBox();
            float modelYScale = -((float)aABB.minY) + 0.0625f;
            poseStack.translate(0.0, (double)(hoverOffset + modelYScale * renderState.open - 0.15f * (1.0f - renderState.open)), 0.0);
            float scale = renderState.open * 0.8f + 0.2f;
            poseStack.scale(scale, scale, scale);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(renderState.time / 20.0f));
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

