/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.client;

import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ServerboundPlayMessage;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import io.netty.buffer.ByteBuf;
import java.util.function.IntUnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;

public record ServerboundEnchantmentLevelMessage(int containerId, Holder<Enchantment> enchantment, Operation operation) implements ServerboundPlayMessage
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundEnchantmentLevelMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ServerboundEnchantmentLevelMessage::containerId, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENCHANTMENT), ServerboundEnchantmentLevelMessage::enchantment, Operation.STREAM_CODEC, ServerboundEnchantmentLevelMessage::operation, ServerboundEnchantmentLevelMessage::new);

    public MessageListener<ServerboundPlayMessage.Context> getListener() {
        return new MessageListener<ServerboundPlayMessage.Context>(){

            public void accept(ServerboundPlayMessage.Context context) {
                AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
                if (abstractContainerMenu instanceof InfuserMenu) {
                    InfuserMenu menu = (InfuserMenu)abstractContainerMenu;
                    if (menu.containerId == ServerboundEnchantmentLevelMessage.this.containerId) {
                        menu.clickEnchantmentLevelButton(ServerboundEnchantmentLevelMessage.this.enchantment, ServerboundEnchantmentLevelMessage.this.operation);
                    }
                }
            }
        };
    }

    public static enum Operation implements IntUnaryOperator
    {
        ADD(enchantmentLevel -> enchantmentLevel + 1),
        REMOVE(enchantmentLevel -> enchantmentLevel - 1),
        ADD_ALL(Integer.MAX_VALUE),
        REMOVE_ALL(Integer.MIN_VALUE);

        public static final StreamCodec<ByteBuf, Operation> STREAM_CODEC;
        private final IntUnaryOperator operator;

        private Operation(int value) {
            this(operand -> value);
        }

        private Operation(IntUnaryOperator operator) {
            this.operator = operator;
        }

        @Override
        public int applyAsInt(int enchantmentLevel) {
            return this.operator.applyAsInt(enchantmentLevel);
        }

        public static Operation remove() {
            return CommonHelper.hasShiftDown() ? REMOVE_ALL : REMOVE;
        }

        public static Operation add() {
            return CommonHelper.hasShiftDown() ? ADD_ALL : ADD;
        }

        static {
            STREAM_CODEC = ExtraStreamCodecs.fromEnum(Operation.class);
        }
    }
}

