/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import com.google.common.collect.Sets;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class PlayerExperienceHelper {
    public static int calculateExperienceDelta(ItemEnchantments itemEnchantments, ItemEnchantments originalEnchantments, RandomSource random) {
        int experiencePoints = PlayerExperienceHelper.collectExperiencePoints(itemEnchantments, originalEnchantments);
        if (experiencePoints > 0) {
            experiencePoints = Mth.ceil((double)((double)experiencePoints / 2.0));
            return experiencePoints + random.nextInt(experiencePoints);
        }
        return 0;
    }

    private static int collectExperiencePoints(ItemEnchantments itemEnchantments, ItemEnchantments originalEnchantments) {
        int experiencePoints = 0;
        for (Holder enchantment : Sets.union((Set)itemEnchantments.keySet(), (Set)originalEnchantments.keySet())) {
            int currentLevel;
            int originalLevel = originalEnchantments.getLevel(enchantment);
            if (originalLevel <= (currentLevel = itemEnchantments.getLevel(enchantment))) continue;
            int originalMinCost = EnchantingBehavior.get().getMinCost((Holder<Enchantment>)enchantment, originalLevel);
            int currentMinCost = EnchantingBehavior.get().getMinCost((Holder<Enchantment>)enchantment, currentLevel);
            experiencePoints += Math.max(0, originalMinCost) - Math.max(0, currentMinCost);
        }
        return experiencePoints;
    }
}

