/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.config.ModifiableItems;
import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.enchantinginfuser.world.level.block.entity.InfuserBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.init.v3.registry.ResourceKeyHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InfuserBlock
extends BaseEntityBlock
implements TickingEntityBlock<InfuserBlockEntity> {
    public static final MapCodec<InfuserBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)InfuserType.CODEC.fieldOf("type").forGetter(InfuserBlock::getType), (App)InfuserBlock.propertiesCodec()).apply((Applicative)instance, InfuserBlock::new));
    public static final Component COMPONENT_CHOOSE = ResourceKeyHelper.getComponent((ResourceKey)Registries.BLOCK, (Identifier)EnchantingInfuser.id("enchanting_infuser.description.choose"));
    public static final Component COMPONENT_CHOOSE_AND_MODIFY = ResourceKeyHelper.getComponent((ResourceKey)Registries.BLOCK, (Identifier)EnchantingInfuser.id("enchanting_infuser.description.choose_and_modify"));
    public static final Component COMPONENT_REPAIR = ResourceKeyHelper.getComponent((ResourceKey)Registries.BLOCK, (Identifier)EnchantingInfuser.id("enchanting_infuser.description.repair"));
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private final InfuserType type;

    public InfuserBlock(InfuserType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public static boolean isValidBookShelf(Level level, BlockPos pos, BlockPos offset) {
        if (EnchantingBehavior.get().getEnchantmentPower(level.getBlockState(pos.offset((Vec3i)offset)), level, pos.offset((Vec3i)offset)) != 0.0f) {
            BlockPos inBetweenPos = pos.offset(offset.getX() / 2, offset.getY(), offset.getZ() / 2);
            return level.getBlockState(inBetweenPos).getCollisionShape((BlockGetter)level, inBetweenPos) != Shapes.block();
        }
        return false;
    }

    public MapCodec<InfuserBlock> codec() {
        return CODEC;
    }

    public InfuserType getType() {
        return this.type;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntityType<? extends InfuserBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.value();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                player.openMenu(state.getMenuProvider(level, pos));
                player.containerMenu.slotsChanged((Container)blockEntity2);
            }
            return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (random.nextInt(16) != 0 || !InfuserBlock.isValidBookShelf(level, pos, offset)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)offset.getX() + random.nextFloat()) - 0.5, (double)((float)offset.getY() - random.nextFloat() - 1.0f), (double)((float)offset.getZ() + random.nextFloat()) - 0.5);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType type) {
        return false;
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean isMoving) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public Component getDescriptionComponent() {
        Component component = this.getType().getConfig().allowModifyingEnchantments == ModifiableItems.UNENCHANTED ? COMPONENT_CHOOSE : COMPONENT_CHOOSE_AND_MODIFY;
        MutableComponent mutableComponent = Component.empty().append(component).withStyle(ChatFormatting.GOLD);
        if (this.getType().getConfig().allowRepairing.isActive()) {
            return mutableComponent.append(CommonComponents.SPACE).append(COMPONENT_REPAIR);
        }
        return mutableComponent;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos, Direction direction) {
        InfuserBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
        if (blockEntity2 instanceof InfuserBlockEntity && !(blockEntity = (InfuserBlockEntity)blockEntity2).getItem(0).isEmpty()) {
            return 15;
        }
        return 0;
    }
}

