/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block.entity;

import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import fuzs.puzzleslib.api.container.v1.MenuProviderWithData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class InfuserBlockEntity
extends EnchantingTableBlockEntity
implements WorldlyContainer,
TickingBlockEntity,
ListBackedContainer,
MenuProviderWithData<InfuserType> {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private LockCode lockKey = LockCode.NO_LOCK;

    public InfuserBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
        this.type = this.getType();
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.value();
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.lockKey = LockCode.fromTag((ValueInput)valueInput);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.lockKey.addToTag(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items, (boolean)true);
    }

    public @Nullable ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (index == 0) {
            return this.getItem(0).isEmpty();
        }
        return false;
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemStack, Direction direction) {
        return index == 0 && (itemStack.isEnchanted() || itemStack.is(Items.ENCHANTED_BOOK));
    }

    public boolean canOpen(Player player) {
        return this.lockKey.canUnlock(player);
    }

    public void clientTick() {
        InfuserBlockEntity.bookAnimationTick((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState(), (EnchantingTableBlockEntity)this);
    }

    public InfuserType getMenuData(ServerPlayer serverPlayer) {
        return ((InfuserBlock)this.getBlockState().getBlock()).getType();
    }

    public @Nullable AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        Block block;
        if (this.canOpen(player) && (block = this.getBlockState().getBlock()) instanceof InfuserBlock) {
            InfuserBlock block2 = (InfuserBlock)block;
            InfuserMenu infuserMenu = new InfuserMenu(block2.getType(), containerId, inventory, (Container)this, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()));
            infuserMenu.addSlotListener(infuserMenu);
            return infuserMenu;
        }
        BaseContainerBlockEntity.sendChestLockedNotifications((Vec3)this.getBlockPos().getCenter(), (Player)player, (Component)this.getDisplayName());
        return null;
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }
}

