/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.im_movens;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.ivangeevo.im_movens.config.ModSettings;
import org.ivangeevo.im_movens.sound.ImMovensSound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImMovensMod
implements ModInitializer {
    public static final String MOD_ID = "im_movens";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"im_movens");
    private static ImMovensMod instance;
    public ModSettings settings;
    public static boolean isHungerGranular;
    private static final String CONFIG_FILE_LOCATION = "./config/btwr/immovensCommon.json";

    public static ImMovensMod getInstance() {
        return instance;
    }

    public static ModSettings getSettings() {
        return ImMovensMod.getInstance().settings;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Im'movens.");
        ImMovensSound.register();
        this.loadSettings();
        if (FabricLoader.getInstance().isModLoaded("granular_hunger")) {
            isHungerGranular = true;
        }
        instance = this;
    }

    public void loadSettings() {
        File file = new File(CONFIG_FILE_LOCATION);
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (ModSettings)gson.fromJson((Reader)fileReader, ModSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Im 'movens settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new ModSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File(CONFIG_FILE_LOCATION);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Im 'movens settings: " + e.getLocalizedMessage());
        }
    }

    static {
        isHungerGranular = false;
    }
}

