/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.im_movens.util;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.ivangeevo.im_movens.ImMovensMod;
import org.ivangeevo.im_movens.sound.ImMovensSound;
import org.ivangeevo.im_movens.util.StatusEffectUtils;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class PlayerEffectsManager {
    private static final PlayerEffectsManager INSTANCE = new PlayerEffectsManager();
    private StatusEffectUtils.GenericState currentGenericState = StatusEffectUtils.GenericState.NORMAL;
    private float distToNextHurtSound = 0.0f;
    private final float THRESHOLD_FOR_NOISE = 6.0f;
    private static final int NAUSEA_TICKS = 100;

    private PlayerEffectsManager() {
    }

    public static PlayerEffectsManager getInstance() {
        return INSTANCE;
    }

    public void onTick(class_1657 player) {
    }

    public void onServerTick(class_1657 player) {
        this.applyNauseaEffect(player);
        this.applyBlindnessEffect(player);
        this.updateAttributes(player);
        this.applySlowHealing(player);
        this.doHurtNoise(player);
    }

    public boolean shouldBeAffected(class_1657 player) {
        return !player.method_7337() && !player.method_7325() && !player.method_29504();
    }

    public void disableJumpIfLow(class_1657 player, CallbackInfo ci) {
        boolean healthCondition;
        int foodLevel = player.method_7344().method_7586();
        boolean fatCondition = false;
        if (ImMovensMod.isHungerGranular) {
            foodLevel = class_3532.method_15384((double)((double)foodLevel / 3.0));
            float fatLevel = player.method_7344().method_7589();
            fatCondition = fatLevel > 54.0f && ImMovensMod.getSettings().isFatPenaltiesEnabled();
        }
        boolean hungerCondition = foodLevel <= 4 && ImMovensMod.getSettings().isHungerPenaltiesEnabled();
        boolean bl = healthCondition = player.method_6032() <= 4.0f && ImMovensMod.getSettings().isHealthPenaltiesEnabled();
        if ((hungerCondition || healthCondition || fatCondition) && this.shouldBeAffected(player)) {
            ci.cancel();
        }
    }

    private void updateAttributes(class_1657 player) {
        class_1324 movementSpeedAttribute = player.method_5996(class_5134.field_23719);
        class_1324 blockBreakSpeedAttribute = player.method_5996(class_5134.field_49076);
        class_1324 attackDamageAttribute = player.method_5996(class_5134.field_23721);
        StatusEffectUtils.GenericState newGenericState = StatusEffectUtils.GenericState.getStateFromPlayerStats(player);
        if (movementSpeedAttribute != null) {
            if (newGenericState != this.currentGenericState) {
                movementSpeedAttribute.method_6202(this.currentGenericState.getModifier());
                movementSpeedAttribute.method_26837(newGenericState.getModifier());
                this.setNextDistToHurtSound(player);
            }
            if (!this.shouldBeAffected(player)) {
                movementSpeedAttribute.method_6202(this.currentGenericState.getModifier());
            } else if (this.shouldBeAffected(player) && !movementSpeedAttribute.method_6196(this.currentGenericState.getModifier().comp_2447())) {
                movementSpeedAttribute.method_26837(newGenericState.getModifier());
            }
            class_2960 legacyHungerModifierIdentifier = class_2960.method_60655((String)"im_movens", (String)"hunger_speed_modifier");
            class_2960 legacyHealthModifierIdentifier = class_2960.method_60655((String)"im_movens", (String)"health_speed_modifier");
            if (movementSpeedAttribute.method_6196(legacyHungerModifierIdentifier)) {
                movementSpeedAttribute.method_6200(legacyHungerModifierIdentifier);
            }
            if (movementSpeedAttribute.method_6196(legacyHealthModifierIdentifier)) {
                movementSpeedAttribute.method_6200(legacyHealthModifierIdentifier);
            }
        }
        if (blockBreakSpeedAttribute != null && newGenericState != this.currentGenericState) {
            blockBreakSpeedAttribute.method_6202(this.currentGenericState.getModifier());
            blockBreakSpeedAttribute.method_26837(newGenericState.getModifier());
        }
        if (attackDamageAttribute != null && newGenericState != this.currentGenericState) {
            attackDamageAttribute.method_6202(this.currentGenericState.getModifier());
            attackDamageAttribute.method_26837(newGenericState.getModifier());
        }
        this.currentGenericState = newGenericState;
    }

    private void applyNauseaEffect(class_1657 player) {
        if (player.method_7344().method_7586() <= 0 && player.field_6012 % 100 == 0 && ImMovensMod.getSettings().isHungerPenaltiesEnabled()) {
            player.method_6092(new class_1293(class_1294.field_5916, 50, 7, true, true));
        }
    }

    private void applyBlindnessEffect(class_1657 player) {
        if (player instanceof class_3222 && player.method_6032() <= 2.0f && ImMovensMod.getSettings().isHealthPenaltiesEnabled() && this.shouldBeAffected(player)) {
            player.method_6092(new class_1293(class_1294.field_5919, 60, 0));
        }
    }

    private void applySlowHealing(class_1657 player) {
        if (player.field_6012 % 600 == 0 && player.method_6032() < player.method_6063() && player.method_7344().method_7586() >= 9 && ImMovensMod.getSettings().isNaturalRegenEnabled() && this.shouldBeAffected(player)) {
            player.method_6025(1.0f);
        }
    }

    private void doHurtNoise(class_1657 player) {
        boolean isRestrictedByMovement;
        boolean doPainSound = ImMovensMod.getSettings().hasPainSounds() && (float)((int)player.field_5994) > this.distToNextHurtSound && ImMovensMod.getSettings().isHealthPenaltiesEnabled() && player.method_6032() <= 6.0f && this.shouldBeAffected(player);
        boolean sneakingBlocks = player.method_5715() && !ImMovensMod.getSettings().hasSneakingPainSounds();
        boolean flyingBlocks = player.method_6128();
        boolean bl = isRestrictedByMovement = sneakingBlocks || flyingBlocks;
        if (doPainSound && !isRestrictedByMovement && !player.method_37908().field_9236) {
            player.method_17356(ImMovensSound.PLAYER_HURT, class_3419.field_15248, 0.5f, this.pitchFromHealth(player) + class_5819.method_43047().method_43057() * 0.1f);
            this.setNextDistToHurtSound(player);
        }
    }

    public void setNextDistToHurtSound(class_1657 player) {
        this.distToNextHurtSound = player.field_5994 + 4.0f * (player.method_6032() / 6.0f);
    }

    private float pitchFromHealth(class_1657 player) {
        return 0.55f + player.method_6032() / 6.0f * 0.45f;
    }
}

