/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.im_movens.util;

import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.ivangeevo.im_movens.ImMovensMod;

public class StatusEffectUtils {

    public static enum AttackPower {
        DYING(-1),
        CRIPPLED(0),
        WOUNDED(1),
        INJURED(2),
        HEALTHY(2);

        private final class_1322 attackModifier;

        private AttackPower(int value) {
            this.attackModifier = new class_1322(class_2960.method_60655((String)"im_movens", (String)"attack_damage_modifier"), (double)value, class_1322.class_1323.field_6328);
        }

        public class_1322 getAttackModifier() {
            return this.attackModifier;
        }

        public static AttackPower fromHealthLevel(float healthLevel) {
            return switch (class_3532.method_15386((float)healthLevel)) {
                case 0, 1, 2 -> DYING;
                case 3, 4 -> CRIPPLED;
                case 5, 6 -> WOUNDED;
                case 7, 8, 9, 10 -> INJURED;
                default -> HEALTHY;
            };
        }
    }

    public static enum GenericState {
        SEVERE(0.25f),
        MAJOR(0.5f),
        MINOR(0.75f),
        NORMAL(1.0f);

        private final class_1322 genericModifier;

        private GenericState(float modifier) {
            this.genericModifier = new class_1322(class_2960.method_60655((String)"im_movens", (String)"generic_modifier"), (double)(modifier - 1.0f), class_1322.class_1323.field_6331);
        }

        public class_1322 getModifier() {
            return this.genericModifier;
        }

        public static GenericState getSeverityState(int severity) {
            return switch (severity) {
                case 1 -> MINOR;
                case 2 -> MAJOR;
                case 3 -> SEVERE;
                default -> NORMAL;
            };
        }

        public static GenericState getStateFromPlayerStats(class_1657 player) {
            int n;
            int n2;
            int foodLevel = player.method_7344().method_7586();
            float healthLevel = player.method_6032();
            int severity = 0;
            if (ImMovensMod.isHungerGranular) {
                foodLevel = class_3532.method_15384((double)((double)foodLevel / 3.0));
                float fatLevel = player.method_7344().method_7589();
                if (ImMovensMod.getSettings().isFatPenaltiesEnabled()) {
                    switch (class_3532.method_15386((float)(fatLevel / 6.0f))) {
                        case 8: {
                            v0 = 1;
                            break;
                        }
                        case 9: {
                            v0 = 2;
                            break;
                        }
                        case 10: {
                            v0 = 3;
                            break;
                        }
                        default: {
                            v0 = 0;
                            break;
                        }
                    }
                } else {
                    v0 = severity = 0;
                }
            }
            if (ImMovensMod.getSettings().isHungerPenaltiesEnabled()) {
                switch (foodLevel) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n2 = 1;
                        break;
                    }
                    default: {
                        n2 = 0;
                        break;
                    }
                }
            } else {
                n2 = 0;
            }
            severity = Math.max(severity, n2);
            if (ImMovensMod.getSettings().isHealthPenaltiesEnabled()) {
                switch (class_3532.method_15386((float)healthLevel)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n = 3;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n = 2;
                        break;
                    }
                    case 7: 
                    case 8: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = 0;
                        break;
                    }
                }
            } else {
                n = 0;
            }
            severity = Math.max(severity, n);
            return GenericState.getSeverityState(severity);
        }
    }
}

