/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.api.v2;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.defaults.ModDiscovererConfigImpl;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ModDiscovererConfig {
    public static Builder builder(String folderName) {
        return new ModDiscovererConfigImpl.BuilderImpl(folderName);
    }

    public String getFolderName();

    public Pattern getFileNameMatcher();

    public boolean searchRecursively();

    public Predicate<String> getDirectoryFilter();

    public Collector getCandidateCollector();

    public boolean getExportToOriginalFolder();

    public boolean allowDirectoryMods();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    public static interface Collector {
        public List<ModCandidate> collect(ModDiscovererConfig var1, Path var2, List<String> var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Builder {
        public Builder fileNameMatcher(String var1);

        public Builder searchRecursively(boolean var1);

        public Builder directoryFilter(Predicate<String> var1);

        public Builder candidateCollector(Collector var1);

        public Builder exportToOriginalFolder(boolean var1);

        public Builder allowDirectoryMods(boolean var1);

        public ModDiscovererConfig build();
    }
}

