/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import fr.catcore.wfvaio.WhichFabricVariantAmIOn;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v1.V1MappingBuilderImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.InternalCacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappingVisitor;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingNsRenamer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingSourceNsSwitch;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingTreeHelper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class MappingsRegistryInstance
extends MappingsRegistry {
    public List<String> vanillaClassNames = new ArrayList<String>();
    private MemoryMappingTree formatted = new MemoryMappingTree();
    private MemoryMappingTree mods;
    private MemoryMappingTree additional;
    private final MemoryMappingTree full = new MemoryMappingTree();
    private String defaultPackage = "";
    private String sourceNamespace = "official";
    private final InternalCacheHandler cacheHandler;

    public MappingsRegistryInstance(InternalCacheHandler cacheHandler) {
        this.cacheHandler = cacheHandler;
        try {
            this.formatVanillaMappings();
            this.mods = MappingTreeHelper.createMappingTree(this.sourceNamespace, this.getTargetNamespace());
            this.additional = MappingTreeHelper.createMappingTree(this.sourceNamespace, this.getTargetNamespace());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void formatVanillaMappings() throws IOException {
        HashMap<String, String> renames = new HashMap<String, String>();
        boolean switchNamespace = false;
        switch (WhichFabricVariantAmIOn.getVariant()) {
            case BABRIC: {
                renames.put(FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ENGLISH), "official");
                switchNamespace = true;
                break;
            }
            case ORNITHE_V2: {
                Boolean merged = VersionHelper.predicate(">=1.3");
                if (merged == null || merged.booleanValue()) break;
                renames.put(FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ENGLISH) + "Official", "official");
                switchNamespace = true;
                break;
            }
            case BABRIC_NEW_FORMAT: {
                renames.put(FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ENGLISH) + "Official", "official");
                switchNamespace = true;
            }
        }
        MappingVisitor visitor = MappingTreeHelper.getNsReorderingVisitor(this.formatted, switchNamespace, renames);
        MappingsRegistry.VANILLA.accept(visitor);
    }

    @Override
    public List<String> getVanillaClassNames() {
        return this.vanillaClassNames;
    }

    @Override
    public MemoryMappingTree getFormattedMappings() {
        return this.formatted;
    }

    @Override
    public void addToFormattedMappings(InputStream stream, Map<String, String> renames) throws IOException {
        MemoryMappingTree extra = MappingTreeHelper.readMappings(stream);
        if (!renames.isEmpty()) {
            MemoryMappingTree renamed = new MemoryMappingTree();
            MappingNsRenamer renamer = new MappingNsRenamer(renamed, renames);
            extra.accept(renamer);
            extra = renamed;
        }
        if (!Objects.equals(extra.getSrcNamespace(), this.formatted.getSrcNamespace()) && extra.getDstNamespaces().contains(this.formatted.getSrcNamespace())) {
            MemoryMappingTree switched = new MemoryMappingTree();
            MappingSourceNsSwitch switcher = new MappingSourceNsSwitch(switched, this.formatted.getSrcNamespace());
            extra.accept(switcher);
            extra = switched;
        }
        this.formatted = MappingTreeHelper.mergeIntoNew(this.formatted, extra);
    }

    @Override
    public void completeFormattedMappings() throws IOException {
        this.formatted.accept(this.full);
        for (MappingTree.ClassMapping classMapping : this.formatted.getClasses()) {
            String className = classMapping.getName(this.getSourceNamespace());
            if (className == null) continue;
            this.vanillaClassNames.add("/" + className + ".class");
        }
        try {
            MappingTreeHelper.exportMappings(this.formatted, this.cacheHandler.resolveMappings("mc_mappings.tiny"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing formatted mappings", e);
        }
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    @Override
    public void addModMappings(Path path) {
        V1MappingBuilderImpl mappingBuilder = new V1MappingBuilderImpl(this.mods);
        try {
            FileUtils.listPathContent(path).stream().filter(file -> file.endsWith(".class")).map(file -> file.replace(".class", "")).forEach(cl -> mappingBuilder.addMapping((String)cl, (cl.contains("/") ? "" : this.defaultPackage) + cl));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void generateModMappings() {
        try {
            this.mods.visitEnd();
            MappingTreeHelper.exportMappings(this.mods, this.cacheHandler.resolveMappings("remapped_mappings.tiny"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while generating mods mappings", e);
        }
        this.addToFullMappings(this.mods);
    }

    @Override
    public MemoryMappingTree getModsMappings() {
        return this.mods;
    }

    @Override
    public MemoryMappingTree getAdditionalMappings() {
        return this.additional;
    }

    @Override
    public void generateAdditionalMappings() {
        this.additional.visitEnd();
        try {
            MappingTreeHelper.exportMappings(this.additional, this.cacheHandler.resolveMappings("extra_mappings.tiny"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while generating remappers mappings", e);
        }
        this.addToFullMappings(this.additional);
    }

    @Override
    public MemoryMappingTree getFullMappings() {
        return this.full;
    }

    @Override
    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public void setSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        try {
            this.mods = MappingTreeHelper.createMappingTree(this.sourceNamespace, this.getTargetNamespace());
            this.additional = MappingTreeHelper.createMappingTree(this.sourceNamespace, this.getTargetNamespace());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTargetNamespace() {
        return FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
    }

    @Override
    public void writeFullMappings() {
        try {
            MappingTreeHelper.exportMappings(this.full, this.cacheHandler.resolveMappings("full_mappings.tiny"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<MappingTree> getRemappingMappings() {
        return List.of(this.getFormattedMappings(), this.getModsMappings(), this.getAdditionalMappings());
    }
}

