/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.InternalCacheHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class V2CacheHandler
implements InternalCacheHandler {
    private final Path contextDirectory;
    private final Path tempDirectory;
    private final Path cacheDirectory;
    private final Path mappingsDirectory;
    private final Path librariesDirectory;

    public V2CacheHandler(Path contextDirectory) {
        this.contextDirectory = contextDirectory;
        this.tempDirectory = this.contextDirectory.resolve("temp");
        this.cacheDirectory = this.contextDirectory.resolve("cache");
        this.mappingsDirectory = this.contextDirectory.resolve("mappings");
        this.librariesDirectory = this.contextDirectory.resolve("libraries");
        List<Path> directories = List.of(this.tempDirectory, this.cacheDirectory, this.mappingsDirectory, this.librariesDirectory);
        for (Path directory : directories) {
            if (Files.exists(directory, new LinkOption[0])) continue;
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory: " + String.valueOf(directory), e);
            }
        }
    }

    @Override
    public Path resolveTemp(String name) {
        return this.tempDirectory.resolve(name);
    }

    @Override
    public Path resolveCache(String name) {
        return this.cacheDirectory.resolve(name);
    }

    @Override
    public Path resolveLibrary(String name) {
        return this.librariesDirectory.resolve(name);
    }

    @Override
    public Path resolveMappings(String name) {
        return this.mappingsDirectory.resolve(name);
    }

    @Override
    public Path resolveRoot(String name) {
        return this.contextDirectory.resolve(name);
    }

    @Override
    public Path getTempDirectory() {
        return this.tempDirectory;
    }
}

