/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.MappingBuilder;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappedElementKind;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class V2MappingBuilderImpl
implements MappingBuilder {
    private final MemoryMappingTree next;

    public V2MappingBuilderImpl(MemoryMappingTree next) {
        this.next = next;
    }

    @Override
    public MappingBuilder.ClassMapping addMapping(String sourceName, String targetName) {
        this.next.visitClass(sourceName);
        this.next.visitDstName(MappedElementKind.CLASS, 0, targetName);
        return new ClassMappingImpl(sourceName, targetName, this.next);
    }

    @Override
    public MappingBuilder.ClassMapping addMapping(String name) {
        this.next.visitClass(name);
        return new ClassMappingImpl(name, null, this.next);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record ClassMappingImpl(String sourceName, @Nullable String targetName, MemoryMappingTree next) implements MappingBuilder.ClassMapping
    {
        private void visit() {
            this.next.visitClass(this.sourceName);
            if (this.targetName != null) {
                this.next.visitDstName(MappedElementKind.CLASS, 0, this.targetName);
            }
        }

        @Override
        public MappingBuilder.ClassMapping field(String sourceName, String targetName, String sourceDescriptor) {
            this.visit();
            this.next.visitField(sourceName, sourceDescriptor);
            if (targetName != null) {
                this.next.visitDstName(MappedElementKind.FIELD, 0, targetName);
            }
            return this;
        }

        @Override
        public MappingBuilder.ClassMapping field(String name, String descriptor) {
            return this.field(name, null, descriptor);
        }

        @Override
        public MappingBuilder.ClassMapping method(String sourceName, String targetName, String sourceDescriptor) {
            this.visit();
            this.next.visitMethod(sourceName, sourceDescriptor);
            if (targetName != null) {
                this.next.visitDstName(MappedElementKind.METHOD, 0, targetName);
            }
            return this;
        }

        @Override
        public MappingBuilder.ClassMapping method(String name, String descriptor) {
            return this.method(name, null, descriptor);
        }
    }
}

