/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings;

import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappedElementKind;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrClass;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrEnvironment;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrMethod;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingTreeHelper;
import io.github.fabriccompatibiltylayers.modremappingapi.api.v1.MappingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipError;
import net.fabricmc.loader.impl.launch.MappingConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public abstract class MappingsRegistry {
    public static final MemoryMappingTree VANILLA;

    public abstract List<String> getVanillaClassNames();

    public abstract MemoryMappingTree getFormattedMappings();

    public abstract void addToFormattedMappings(InputStream var1, Map<String, String> var2) throws IOException;

    public abstract void completeFormattedMappings() throws IOException;

    public abstract void addModMappings(Path var1);

    public abstract void generateModMappings();

    public abstract MemoryMappingTree getModsMappings();

    public abstract MemoryMappingTree getAdditionalMappings();

    public abstract void generateAdditionalMappings();

    public abstract MemoryMappingTree getFullMappings();

    public abstract String getSourceNamespace();

    public abstract String getTargetNamespace();

    public abstract void writeFullMappings();

    public abstract List<MappingTree> getRemappingMappings();

    public void addToFullMappings(MappingTree mappingTreeView) {
        try {
            MappingTreeHelper.merge(this.getFullMappings(), mappingTreeView);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isSourceNamespaceObf() {
        return Objects.equals(this.getSourceNamespace(), "official");
    }

    public void completeMappingsFromTr(TrEnvironment trEnvironment, String src) {
        int srcNamespace = this.getFullMappings().getNamespaceId(src);
        int trueSrcNamespace = this.getFullMappings().getNamespaceId(this.getFullMappings().getSrcNamespace());
        Map<ExtendedClassMember, List<String>> classMembers = this.getClassMembers(trEnvironment, srcNamespace);
        this.gatherChildClassCandidates(trEnvironment, classMembers);
        try {
            this.getFullMappings().visitHeader();
            this.getFullMappings().visitNamespaces(this.getFullMappings().getSrcNamespace(), this.getFullMappings().getDstNamespaces());
            this.getFullMappings().visitContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int propagated = this.propagateMembers(trEnvironment, classMembers, srcNamespace, trueSrcNamespace);
        Constants.MAIN_LOGGER.info("Propagated: " + propagated + " methods from namespace " + src);
    }

    private int propagateMembers(TrEnvironment trEnvironment, Map<ExtendedClassMember, List<String>> classMembers, int srcNamespace, int trueSrcNamespace) {
        int propagated = 0;
        for (Map.Entry<ExtendedClassMember, List<String>> entry : classMembers.entrySet()) {
            ExtendedClassMember member = entry.getKey();
            for (String child : entry.getValue()) {
                TrMethod trMethod;
                MappingTree.ClassMapping classMapping;
                TrClass trClass = trEnvironment.getClass(child);
                if (trClass == null) continue;
                if (srcNamespace == trueSrcNamespace) {
                    this.getFullMappings().visitClass(child);
                } else {
                    this.getFullMappings().visitClass(this.getFullMappings().mapClassName(child, srcNamespace, trueSrcNamespace));
                }
                if ((classMapping = this.getFullMappings().getClass(child, srcNamespace)) == null || (trMethod = trClass.getMethod(member.name, member.desc)) == null) continue;
                try {
                    Boolean actualPropagated = this.tryPropagatingMember(srcNamespace, trueSrcNamespace, member, classMapping);
                    if (actualPropagated == null || !actualPropagated.booleanValue()) continue;
                    ++propagated;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return propagated;
    }

    @Nullable
    private Boolean tryPropagatingMember(int srcNamespace, int trueSrcNamespace, ExtendedClassMember member, MappingTree.ClassMapping classMapping) throws IOException {
        if (srcNamespace == trueSrcNamespace) {
            this.getFullMappings().visitMethod(member.name, member.desc);
        } else {
            MappingTree.MethodMapping memberMapping = this.getFullMappings().getMethod(member.owner, member.name, member.desc, srcNamespace);
            if (memberMapping == null) {
                return null;
            }
            this.getFullMappings().visitMethod(memberMapping.getSrcName(), memberMapping.getSrcDesc());
            this.getFullMappings().visitDstName(MappedElementKind.METHOD, srcNamespace, member.name);
            this.getFullMappings().visitDstDesc(MappedElementKind.METHOD, srcNamespace, member.desc);
        }
        MappingTree.MethodMapping methodMapping = this.getFullMappings().getMethod(member.owner, member.name, member.desc, srcNamespace);
        if (methodMapping == null) {
            return null;
        }
        MappingTree.MethodMapping newMethodMapping = classMapping.getMethod(member.name, member.desc, srcNamespace);
        boolean actualPropagated = false;
        for (String namespace : this.getFullMappings().getDstNamespaces()) {
            String targetDesc;
            String targetName;
            int targetNamespace = this.getFullMappings().getNamespaceId(namespace);
            if (targetNamespace == srcNamespace) continue;
            if (newMethodMapping.getName(targetNamespace) == null && (targetName = methodMapping.getName(targetNamespace)) != null) {
                this.getFullMappings().visitDstName(MappedElementKind.METHOD, targetNamespace, targetName);
                actualPropagated = true;
            }
            if (newMethodMapping.getDesc(targetNamespace) != null || (targetDesc = methodMapping.getDesc(targetNamespace)) == null) continue;
            this.getFullMappings().visitDstDesc(MappedElementKind.METHOD, targetNamespace, targetDesc);
            actualPropagated = true;
        }
        return actualPropagated;
    }

    private Map<ExtendedClassMember, List<String>> getClassMembers(TrEnvironment trEnvironment, int srcNamespace) {
        HashMap<ExtendedClassMember, List<String>> classMembers = new HashMap<ExtendedClassMember, List<String>>();
        for (MappingTree.ClassMapping classMapping : this.getFullMappings().getClasses()) {
            String className = classMapping.getName(srcNamespace);
            TrClass trClass = trEnvironment.getClass(className);
            if (trClass == null) continue;
            List children = trClass.getChildren().stream().map(TrClass::getName).collect(Collectors.toList());
            for (MappingTree.MethodMapping methodMapping : classMapping.getMethods()) {
                TrMethod method;
                String methodName = methodMapping.getName(srcNamespace);
                String methodDesc = methodMapping.getDesc(srcNamespace);
                if (methodName == null || methodDesc == null || (method = trClass.getMethod(methodName, methodDesc)) == null || !method.isVirtual()) continue;
                classMembers.put(new ExtendedClassMember(methodMapping.getName(srcNamespace), methodMapping.getDesc(srcNamespace), className), children);
            }
        }
        return classMembers;
    }

    private void gatherChildClassCandidates(TrEnvironment trEnvironment, Map<ExtendedClassMember, List<String>> classMembers) {
        for (Map.Entry<ExtendedClassMember, List<String>> entry : classMembers.entrySet()) {
            ArrayList<String> toAdd = new ArrayList<String>((Collection)entry.getValue());
            while (!toAdd.isEmpty()) {
                TrClass trClass = trEnvironment.getClass((String)toAdd.remove(0));
                if (trClass == null) continue;
                List<String> children = trClass.getChildren().stream().map(TrClass::getName).toList();
                for (String child : children) {
                    if (entry.getValue().contains(child)) continue;
                    toAdd.add(child);
                    entry.getValue().add(child);
                }
            }
        }
    }

    static {
        block9: {
            URL url = MappingConfiguration.class.getClassLoader().getResource("mappings/mappings.tiny");
            if (url != null) {
                try (InputStream inputStream = url.openConnection().getInputStream();){
                    VANILLA = MappingTreeHelper.readMappings(inputStream);
                    break block9;
                }
                catch (IOException | ZipError e) {
                    throw new RuntimeException("Error reading " + String.valueOf(url), e);
                }
            }
            VANILLA = null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ExtendedClassMember
    extends MappingUtils.ClassMember {
        public final String owner;

        public ExtendedClassMember(String name, @Nullable String desc, String owner) {
            super(name, desc);
            this.owner = owner;
        }
    }
}

