/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v1;

import fr.catcore.modremapperapi.api.ModRemapper;
import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModDiscovererConfig;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemapLibrary;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemappingFlags;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v0.V0ModRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v1.V1CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v1.V1MappingBuilderImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.BaseModRemapperContext;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.InternalCacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.LibraryHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.MappingsRegistryInstance;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.MixinData;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.ModDiscoverer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.defaults.DefaultModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.ModTrRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.SoftLockFixer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.VisitorInfosImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.visitor.MRAApplyVisitor;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class ModRemapperV1Context
extends BaseModRemapperContext<io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper> {
    private final Set<RemappingFlags> remapFlags = new HashSet<RemappingFlags>();
    private final List<io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper> remappers = new ArrayList<io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper>();
    private final MixinData mixinData = new MixinData();
    private final InternalCacheHandler cacheHandler = new V1CacheHandler();
    private final MappingsRegistryInstance mappingsRegistry = new MappingsRegistryInstance(this.cacheHandler);
    private final LibraryHandler libraryHandler = new LibraryHandler();
    public static ModRemapperV1Context INSTANCE;
    private static final String v0EntrypointName = "mod-remapper-api:modremapper";
    private static final String v1EntrypointName = "mod-remapper-api:modremapper_v1";

    public ModRemapperV1Context() {
        super("mod-remapping-api_v1");
        INSTANCE = this;
    }

    @Override
    public void init() {
        for (io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper remapper : this.remappers) {
            remapper.getDefaultPackage().ifPresent(this.mappingsRegistry::setDefaultPackage);
            remapper.getSourceNamespace().ifPresent(this.mappingsRegistry::setSourceNamespace);
            remapper.getExtraMapping().ifPresent(inputStreamSupplier -> {
                try {
                    this.mappingsRegistry.addToFormattedMappings((InputStream)inputStreamSupplier.get(), new HashMap<String, String>());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            if (!remapper.remapMixins()) continue;
            this.remapFlags.add(RemappingFlags.MIXIN);
        }
        try {
            this.mappingsRegistry.completeFormattedMappings();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gatherLibraries();
        this.registerAdditionalMappings();
        this.mappingsRegistry.generateAdditionalMappings();
    }

    @Override
    public void remapMods(Map<ModCandidate, Path> pathMap) {
        Constants.MAIN_LOGGER.debug("Starting jar remapping!");
        SoftLockFixer.preloadClasses();
        TinyRemapper remapper = ModTrRemapper.makeRemapper(this);
        Constants.MAIN_LOGGER.debug("Remapper created!");
        ModTrRemapper.remapMods(remapper, pathMap, this);
        Constants.MAIN_LOGGER.debug("Jar remapping done!");
        this.mappingsRegistry.writeFullMappings();
    }

    @Override
    public void afterRemap() {
        this.remappers.forEach(io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper::afterRemap);
    }

    private List<ModCandidate> collectCandidates(ModDiscovererConfig config, Path modPath, List<String> entries) {
        boolean fabric = false;
        boolean hasClass = false;
        for (String entry : entries) {
            if (entry.endsWith("fabric.mod.json") || entry.endsWith("quilt.mod.json") || entry.endsWith("quilt.mod.json5")) {
                fabric = true;
                break;
            }
            if (!entry.endsWith(".class")) continue;
            hasClass = true;
        }
        ArrayList<ModCandidate> list = new ArrayList<ModCandidate>();
        if (hasClass && !fabric) {
            list.add(new DefaultModCandidate(modPath, config));
        }
        return list;
    }

    @Override
    public List<io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper> discoverMods(boolean remapClassEdits) {
        HashMap<String, List<String>> excluded = new HashMap<String, List<String>>();
        HashSet modFolders = new HashSet();
        for (io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper remapper : this.remappers) {
            Collections.addAll(modFolders, remapper.getJarFolders());
            if (!(remapper instanceof V0ModRemapper)) continue;
            V0ModRemapper v0Remapper = (V0ModRemapper)remapper;
            excluded.putAll(v0Remapper.getExclusions());
        }
        ArrayList<ModCandidate> candidates = new ArrayList<ModCandidate>();
        HashMap<ModDiscovererConfig, ModDiscoverer> config2Discoverer = new HashMap<ModDiscovererConfig, ModDiscoverer>();
        for (Object modFolder : modFolders) {
            ModDiscovererConfig modDiscovererConfig = ModDiscovererConfig.builder((String)modFolder).fileNameMatcher("(.+).(jar|zip)$").candidateCollector(this::collectCandidates).build();
            ModDiscoverer discoverer = new ModDiscoverer(modDiscovererConfig);
            config2Discoverer.put(modDiscovererConfig, discoverer);
            candidates.addAll(discoverer.collect());
        }
        try {
            this.handleV0Excluded(candidates, excluded);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Map<ModDiscovererConfig, List<ModCandidate>> config2Candidates = candidates.stream().collect(Collectors.groupingBy(ModCandidate::getDiscovererConfig));
        for (Map.Entry entry : config2Candidates.entrySet()) {
            ModDiscovererConfig config = (ModDiscovererConfig)entry.getKey();
            try {
                ((ModDiscoverer)config2Discoverer.get(config)).excludeClassEdits((List)entry.getValue(), this.cacheHandler, this.mappingsRegistry);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        candidates.forEach(candidate -> this.mappingsRegistry.addModMappings(candidate.getPath()));
        this.mappingsRegistry.generateModMappings();
        HashMap<ModCandidate, Path> candidateToOutput = new HashMap<ModCandidate, Path>();
        for (Map.Entry<ModDiscovererConfig, List<ModCandidate>> entry : config2Candidates.entrySet()) {
            ModDiscovererConfig config = entry.getKey();
            candidateToOutput.putAll(((ModDiscoverer)config2Discoverer.get(config)).computeDestinations(entry.getValue(), this.cacheHandler));
        }
        if (!candidateToOutput.isEmpty()) {
            this.remapMods(candidateToOutput);
        }
        candidateToOutput.values().forEach(arg_0 -> ModRemapperV1Context.lambda$discoverMods$2(FabricLauncherBase.getLauncher(), arg_0));
        return new ArrayList<io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper>();
    }

    private void handleV0Excluded(List<ModCandidate> mods, Map<String, List<String>> excludedMap) throws IOException, URISyntaxException {
        for (ModCandidate modCandidate : mods) {
            if (!excludedMap.containsKey(modCandidate.getId())) continue;
            if (Files.isDirectory(modCandidate.getPath(), new LinkOption[0])) {
                for (String excluded : excludedMap.get(modCandidate.getId())) {
                    if (!Files.deleteIfExists(modCandidate.getPath().resolve(excluded))) continue;
                    Constants.MAIN_LOGGER.debug(ModRemapperV1Context.jvmdowngrader$concat$handleV0Excluded$1(String.valueOf(modCandidate.getPath().resolve(excluded))));
                }
                continue;
            }
            FileUtils.removeEntriesFromZip(modCandidate.getPath(), excludedMap.get(modCandidate.getId()));
        }
    }

    @Override
    public void gatherRemappers() {
        List<V0ModRemapper> v0Remappers = J_U_S_Stream.toList(FabricLoader.getInstance().getEntrypoints(v0EntrypointName, ModRemapper.class).stream().map(V0ModRemapper::new));
        this.remappers.addAll(v0Remappers);
        this.remappers.addAll(FabricLoader.getInstance().getEntrypoints(v1EntrypointName, io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper.class));
        if (this.remappers.size() == 1) {
            this.remappers.clear();
        }
    }

    @Override
    public MappingsRegistry getMappingsRegistry() {
        return this.mappingsRegistry;
    }

    private void registerAdditionalMappings() {
        V1MappingBuilderImpl builder = new V1MappingBuilderImpl(this.mappingsRegistry.getAdditionalMappings());
        for (io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper remapper : this.remappers) {
            remapper.registerMappings(builder);
        }
    }

    @Override
    public void addToRemapperBuilder(TinyRemapper.Builder builder) {
        VisitorInfosImpl preInfos = new VisitorInfosImpl();
        VisitorInfosImpl postInfos = new VisitorInfosImpl();
        for (io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper modRemapper : this.remappers) {
            modRemapper.registerPreVisitors(preInfos);
            modRemapper.registerPostVisitors(postInfos);
        }
        builder.extraPreApplyVisitor(new MRAApplyVisitor(preInfos));
        builder.extraPostApplyVisitor(new MRAApplyVisitor(postInfos));
    }

    @Override
    public Set<RemappingFlags> getRemappingFlags() {
        return this.remapFlags;
    }

    @Override
    public LibraryHandler getLibraryHandler() {
        return this.libraryHandler;
    }

    @Override
    public MixinData getMixinData() {
        return this.mixinData;
    }

    @Override
    public void gatherLibraries() {
        this.libraryHandler.init(this.mappingsRegistry.getSourceNamespace(), this.cacheHandler);
        ArrayList libraries = new ArrayList();
        this.remappers.forEach(remapper -> remapper.addRemapLibraries(libraries, FabricLoader.getInstance().getEnvironmentType()));
        this.libraryHandler.cacheLibraries(new ArrayList<RemapLibrary>(libraries));
    }

    @Override
    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    private static /* synthetic */ void lambda$discoverMods$2(FabricLauncher rec$, Path x$0) {
        rec$.addToClassPath(x$0, new String[0]);
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleV0Excluded$1(String string) {
        return "File deleted: " + string;
    }
}

